/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_ATTACHMENTS = "attachments";
    public static final String PROPERTY_BODY = "body";
    public static final String PROPERTY_HEADERS = "headers";
    public static final String PROPERTY_METHOD = "method";
    public static final String PROPERTY_ORIGINAL_URL = "originalUrl";
    public static final String PROPERTY_QUERY = "query";
    public static final String PROPERTY_PASSTHROUGH = "passthrough";
    public static final String PROPERTY_URL = "url";
    private UUID id;
    private JsonObject attachments;
    private JsonObject body;
    private JsonObject headers;
    private String method;
    private String originalUrl;
    private JsonObject query;
    private JsonObject passthrough;
    private String url;

    private Message(UUID id, JsonObject attachments, JsonObject body, JsonObject headers, String method, String originalUrl, JsonObject query, JsonObject passthrough, String url) {
        if (id == null) {
            throw new IllegalArgumentException("Message id must not be null");
        }
        if (attachments == null) {
            throw new IllegalArgumentException("Message attachments must not be null");
        }
        if (body == null) {
            throw new IllegalArgumentException("Message body must not be null");
        }
        if (headers == null) {
            throw new IllegalArgumentException("Message headers must not be null");
        }
        if (passthrough == null) {
            throw new IllegalArgumentException("Message passthrough must not be null");
        }
        this.id = id;
        this.attachments = attachments;
        this.body = body;
        this.headers = headers;
        this.method = method;
        this.originalUrl = originalUrl;
        this.query = query;
        this.passthrough = passthrough;
        this.url = url;
    }

    public UUID getId() {
        return this.id;
    }

    public JsonObject getAttachments() {
        return this.attachments;
    }

    public JsonObject getBody() {
        return this.body;
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public String getOriginalUrl() {
        return this.originalUrl;
    }

    public JsonObject getQuery() {
        return this.query;
    }

    public JsonObject getPassthrough() {
        return this.passthrough;
    }

    public String getUrl() {
        return this.url;
    }

    public JsonObject toJsonObject() {
        JsonObjectBuilder builder = Json.createObjectBuilder().add(PROPERTY_ID, this.id.toString()).add(PROPERTY_ATTACHMENTS, (JsonValue)this.attachments).add(PROPERTY_BODY, (JsonValue)this.body).add(PROPERTY_HEADERS, (JsonValue)this.headers).add(PROPERTY_PASSTHROUGH, (JsonValue)this.passthrough);
        Message.addJsonFieldToBuilderIfExist(builder, PROPERTY_METHOD, this.method);
        Message.addJsonFieldToBuilderIfExist(builder, PROPERTY_ORIGINAL_URL, this.originalUrl);
        Message.addJsonFieldToBuilderIfExist(builder, PROPERTY_QUERY, this.query);
        Message.addJsonFieldToBuilderIfExist(builder, PROPERTY_URL, this.url);
        return builder.build();
    }

    private static JsonObjectBuilder addJsonFieldToBuilderIfExist(JsonObjectBuilder builder, String name, Object value) {
        if (value != null) {
            if (value instanceof JsonObject) {
                builder.add(name, (JsonValue)((JsonObject)value));
            } else if (value instanceof String) {
                builder.add(name, (String)value);
            } else {
                throw new RuntimeException("Unknown type of the property to add to the Message");
            }
        }
        return builder;
    }

    public String toString() {
        JsonObject json = this.toJsonObject();
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)writer);
        jsonWriter.writeObject(json);
        jsonWriter.close();
        return writer.toString();
    }

    public static final class Builder {
        private UUID id = UUID.randomUUID();
        private JsonObject attachments = Json.createObjectBuilder().build();
        private JsonObject body = Json.createObjectBuilder().build();
        private JsonObject headers = Json.createObjectBuilder().build();
        private String method;
        private String originalUrl;
        private JsonObject query;
        private JsonObject passthrough = Json.createObjectBuilder().build();
        private String url;

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder attachments(JsonObject attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder body(JsonObject body) {
            this.body = body;
            return this;
        }

        public Builder headers(JsonObject headers) {
            this.headers = headers;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder originalUrl(String originalUrl) {
            this.originalUrl = originalUrl;
            return this;
        }

        public Builder query(JsonObject query) {
            this.query = query;
            return this;
        }

        public Builder passthrough(JsonObject passthrough) {
            this.passthrough = passthrough;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Message build() {
            return new Message(this.id, this.attachments, this.body, this.headers, this.method, this.originalUrl, this.query, this.passthrough, this.url);
        }
    }
}

