/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.api;

import io.elastic.api.HttpReply;
import io.elastic.api.Message;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventEmitter {
    private static final Logger logger = LoggerFactory.getLogger(EventEmitter.class);
    private Callback errorCallback;
    private Callback dataCallback;
    private Callback snapshotCallback;
    private Callback reboundCallback;
    private Callback updateKeysCallback;
    private Callback httpReplyCallback;

    private EventEmitter(Callback errorCallback, Callback dataCallback, Callback snapshotCallback, Callback reboundCallback, Callback updateKeysCallback, Callback httpReplyCallback) {
        this.errorCallback = errorCallback;
        this.dataCallback = dataCallback;
        this.snapshotCallback = snapshotCallback;
        this.reboundCallback = reboundCallback;
        this.updateKeysCallback = updateKeysCallback;
        this.httpReplyCallback = httpReplyCallback;
    }

    public EventEmitter emitException(Exception e) {
        return this.emit(this.errorCallback, e);
    }

    public EventEmitter emitData(Message message) {
        return this.emit(this.dataCallback, message);
    }

    public EventEmitter emitSnapshot(JsonObject snapshot) {
        return this.emit(this.snapshotCallback, snapshot);
    }

    public EventEmitter emitRebound(Object reason) {
        return this.emit(this.reboundCallback, reason);
    }

    public EventEmitter emitUpdateKeys(JsonObject object) {
        return this.emitOptional(this.updateKeysCallback, "updateKeys", object);
    }

    public EventEmitter emitHttpReply(HttpReply reply) {
        return this.emitOptional(this.httpReplyCallback, "httpReply", reply);
    }

    private EventEmitter emit(Callback callback, Object value) {
        callback.receive(value);
        return this;
    }

    private EventEmitter emitOptional(Callback callback, String eventName, Object value) {
        if (callback == null) {
            logger.info("Event {} emitted but no callback is registered", (Object)eventName);
        } else {
            callback.receive(value);
        }
        return this;
    }

    public static interface Callback {
        public void receive(Object var1);
    }

    public static final class Builder {
        private Callback errorCallback;
        private Callback dataCallback;
        private Callback snapshotCallback;
        private Callback reboundCallback;
        private Callback updateKeysCallback;
        private Callback httpReplyCallback;

        public Builder onError(Callback callback) {
            this.errorCallback = callback;
            return this;
        }

        public Builder onData(Callback callback) {
            this.dataCallback = callback;
            return this;
        }

        public Builder onSnapshot(Callback callback) {
            this.snapshotCallback = callback;
            return this;
        }

        public Builder onRebound(Callback callback) {
            this.reboundCallback = callback;
            return this;
        }

        public Builder onUpdateKeys(Callback callback) {
            this.updateKeysCallback = callback;
            return this;
        }

        public Builder onHttpReplyCallback(Callback callback) {
            this.httpReplyCallback = callback;
            return this;
        }

        public EventEmitter build() {
            if (this.errorCallback == null) {
                throw new IllegalStateException("'onError' callback is required");
            }
            if (this.dataCallback == null) {
                throw new IllegalStateException("'onData' callback is required");
            }
            if (this.snapshotCallback == null) {
                throw new IllegalStateException("'onSnapshot' callback is required");
            }
            if (this.reboundCallback == null) {
                throw new IllegalStateException("'onRebound' callback is required");
            }
            if (this.httpReplyCallback == null) {
                throw new IllegalStateException("'onHttpReplyCallback' callback is required");
            }
            return new EventEmitter(this.errorCallback, this.dataCallback, this.snapshotCallback, this.reboundCallback, this.updateKeysCallback, this.httpReplyCallback);
        }
    }
}

