/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.elastic.api.EventEmitter;
import io.elastic.sailor.ApiClient;
import io.elastic.sailor.Step;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateKeysCallback
implements EventEmitter.Callback {
    private static final Logger logger = LoggerFactory.getLogger(UpdateKeysCallback.class);
    private final Step step;
    private final ApiClient apiClient;

    @Inject
    public UpdateKeysCallback(@Named(value="StepJson") Step step, ApiClient apiClient) {
        this.step = step;
        this.apiClient = apiClient;
    }

    @Override
    public void receive(Object object) {
        String stepId = this.step.getId();
        logger.info("Update to update keys for step {}", (Object)stepId);
        JsonObject keys = (JsonObject)object;
        JsonObject body = Json.createObjectBuilder().add("keys", (JsonValue)keys).build();
        JsonObject config = this.step.getCfg();
        JsonString accountId = config.getJsonString("_account");
        if (accountId == null) {
            throw new IllegalStateException("Component emitted 'updateKeys' event but no account is configured for step " + stepId);
        }
        JsonObject response = this.apiClient.updateAccount(accountId.getString(), body);
        logger.info("Updated account: {}", (Object)response);
        logger.info("Successfully updated keys for step {}", (Object)stepId);
    }
}

