/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import com.rabbitmq.client.AMQP;
import io.elastic.api.Message;
import io.elastic.sailor.AmqpService;
import io.elastic.sailor.ExecutionContext;
import io.elastic.sailor.impl.CountingCallbackImpl;
import io.elastic.sailor.impl.CryptoServiceImpl;
import java.util.Map;

public class ReboundCallback
extends CountingCallbackImpl {
    private static final String HEADER_REBOUND_REASON = "reboundReason";
    private static final String HEADER_REBOUND_ITERATION = "reboundIteration";
    private ExecutionContext executionContext;
    private AmqpService amqp;
    private CryptoServiceImpl cipher;
    private Integer reboundLimit;
    private Integer reboundInitialExpiration;

    @Inject
    public ReboundCallback(@Assisted ExecutionContext executionContext, AmqpService amqp, CryptoServiceImpl cipher, @Named(value="ELASTICIO_REBOUND_LIMIT") Integer reboundLimit, @Named(value="ELASTICIO_REBOUND_INITIAL_EXPIRATION") Integer reboundInitialExpiration) {
        this.executionContext = executionContext;
        this.amqp = amqp;
        this.cipher = cipher;
        this.reboundLimit = reboundLimit;
        this.reboundInitialExpiration = reboundInitialExpiration;
    }

    @Override
    public void receiveData(Object data) {
        int reboundIteration = this.getReboundIteration();
        if (reboundIteration > this.reboundLimit) {
            throw new RuntimeException("Rebound limit exceeded");
        }
        Message message = this.executionContext.getMessage();
        byte[] payload = this.cipher.encryptMessage(message).getBytes();
        Map<String, Object> headers = this.executionContext.buildDefaultHeaders();
        headers.put(HEADER_REBOUND_REASON, data.toString());
        headers.put(HEADER_REBOUND_ITERATION, reboundIteration);
        Integer expiration = this.getReboundExpiration(reboundIteration);
        this.amqp.sendRebound(payload, this.makeReboundOptions(headers, expiration));
    }

    private int getReboundIteration() {
        Map<String, Object> headers = this.executionContext.getHeaders();
        Object reboundIteration = headers.get(HEADER_REBOUND_ITERATION);
        if (reboundIteration != null) {
            try {
                return Integer.parseInt(reboundIteration.toString()) + 1;
            }
            catch (Exception e) {
                throw new RuntimeException("Not a number in reboundIteration header: " + reboundIteration);
            }
        }
        return 1;
    }

    protected Integer getReboundExpiration(int reboundIteration) {
        return Double.valueOf(Math.pow(2.0, reboundIteration - 1)).intValue() * this.reboundInitialExpiration;
    }

    protected AMQP.BasicProperties makeReboundOptions(Map<String, Object> headers, Integer expiration) {
        return new AMQP.BasicProperties.Builder().contentType("application/json").contentEncoding("utf8").expiration(Integer.toString(expiration)).headers(headers).build();
    }
}

