/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import io.elastic.api.JSON;
import io.elastic.sailor.UnexpectedStatusCodeException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import javax.json.JsonObject;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)HttpUtils.class.getName());

    public static String postJson(String url, JsonObject body) throws IOException {
        return HttpUtils.postJson(url, body, 0);
    }

    public static JsonObject getJson(String url, UsernamePasswordCredentials credentials) {
        return HttpUtils.getJson(url, credentials, 0);
    }

    public static JsonObject putJson(String url, JsonObject body, UsernamePasswordCredentials credentials) {
        return HttpUtils.putJson(url, body, credentials, 0);
    }

    public static String postJson(String url, JsonObject body, int retryCount) throws IOException {
        return HttpUtils.postJson(url, body, null, retryCount);
    }

    public static String postJson(String url, JsonObject body, UsernamePasswordCredentials credentials, int retryCount) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)HttpUtils.createStringEntity(body));
        String result = HttpUtils.sendHttpRequest((HttpUriRequest)httpPost, credentials, retryCount);
        if (result == null) {
            throw new RuntimeException("Null response received");
        }
        logger.info("Successfully posted json {} bytes length", (Object)body.toString().length());
        return result;
    }

    public static JsonObject getJson(String url, UsernamePasswordCredentials credentials, int retryCount) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.addHeader("User-Agent", "eio-sailor-java");
        String content = HttpUtils.sendHttpRequest((HttpUriRequest)httpGet, credentials, retryCount);
        if (content == null) {
            throw new RuntimeException("Null response received");
        }
        return JSON.parseObject(content);
    }

    public static JsonObject putJson(String url, JsonObject body, UsernamePasswordCredentials credentials, int retryCount) {
        HttpPut httpPut = new HttpPut(url);
        httpPut.addHeader("Content-Type", "application/json");
        httpPut.setEntity((HttpEntity)HttpUtils.createStringEntity(body));
        String content = HttpUtils.sendHttpRequest((HttpUriRequest)httpPut, credentials, retryCount);
        if (content == null) {
            throw new RuntimeException("Null response received");
        }
        logger.info("Successfully put json {} bytes length", (Object)body.toString().length());
        return JSON.parseObject(content);
    }

    public static void delete(String url, UsernamePasswordCredentials credentials, int retryCount) {
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.addHeader("Content-Type", "application/json");
        HttpUtils.sendHttpRequest((HttpUriRequest)httpDelete, credentials, retryCount);
        logger.info("Successfully sent delete");
    }

    private static StringEntity createStringEntity(JsonObject body) {
        try {
            return new StringEntity(JSON.stringify(body));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String sendHttpRequest(HttpUriRequest request, UsernamePasswordCredentials credentials, int retryCount) {
        CloseableHttpClient httpClient = HttpClients.custom().setRetryHandler((exception, executionCount, context) -> {
            if (executionCount >= retryCount) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return true;
            }
            return exception instanceof SocketException;
        }).build();
        logger.info("Sending {} request to {}", (Object)request.getMethod(), (Object)request.getURI());
        try {
            HttpUtils.auth((HttpRequest)request, request.getURI().toURL(), credentials);
            CloseableHttpResponse response = httpClient.execute(request);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            logger.info("Got {} response", (Object)statusCode);
            if (statusCode >= 400) {
                throw new UnexpectedStatusCodeException(statusCode);
            }
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null) {
                String string = null;
                return string;
            }
            String result = EntityUtils.toString((HttpEntity)responseEntity);
            EntityUtils.consume((HttpEntity)responseEntity);
            logger.info("Successfully consumed response entity");
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void auth(HttpRequest request, URL url, UsernamePasswordCredentials credentials) {
        if (credentials == null) {
            credentials = HttpUtils.retrieveCredentialsFromUrl(url);
        }
        try {
            Header header = new BasicScheme().authenticate((Credentials)credentials, request, null);
            request.addHeader(header);
        }
        catch (AuthenticationException e) {
            throw new RuntimeException(e);
        }
    }

    private static UsernamePasswordCredentials retrieveCredentialsFromUrl(URL url) {
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            throw new IllegalArgumentException("User info is missing in the given url: " + url);
        }
        String decodedUserInfo = HttpUtils.urlDecode(userInfo);
        String[] userAndPassword = decodedUserInfo.split(":");
        if (userAndPassword.length != 2) {
            throw new IllegalArgumentException("Either username or password is missing");
        }
        return new UsernamePasswordCredentials(userAndPassword[0], userAndPassword[1]);
    }

    private static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

