/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.elastic.api.EventEmitter;
import io.elastic.api.HttpReply;
import io.elastic.sailor.AmqpService;
import io.elastic.sailor.ExecutionContext;
import io.elastic.sailor.impl.CryptoServiceImpl;
import io.elastic.sailor.impl.DataCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReplyCallback
implements EventEmitter.Callback {
    private static final Logger logger = LoggerFactory.getLogger(DataCallback.class);
    private AmqpService amqp;
    private CryptoServiceImpl cipher;
    private ExecutionContext executionContext;

    @Inject
    public HttpReplyCallback(@Assisted ExecutionContext executionContext, AmqpService amqp, CryptoServiceImpl cipher) {
        this.executionContext = executionContext;
        this.amqp = amqp;
        this.cipher = cipher;
    }

    @Override
    public void receive(Object data) {
        HttpReply reply = (HttpReply)data;
        JsonObjectBuilder headers = Json.createObjectBuilder();
        reply.getHeaders().entrySet().stream().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
        JsonObject payload = Json.createObjectBuilder().add("statusCode", reply.getStatus()).add("body", this.getContentAsString(reply)).add("headers", (JsonValue)headers.build()).build();
        byte[] encryptedPayload = this.cipher.encryptJsonObject(payload).getBytes();
        this.amqp.sendHttpReply(encryptedPayload, this.executionContext.buildAmqpProperties());
    }

    private String getContentAsString(HttpReply reply) {
        try {
            return this.inputStreamAsString(reply.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String inputStreamAsString(InputStream input) throws IOException {
        StringWriter output = new StringWriter();
        char[] buffer = new char[4096];
        InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
        int n = 0;
        while (-1 != (n = reader.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toString();
    }
}

