/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.elastic.api.Function;
import io.elastic.sailor.ComponentDescriptorResolver;
import io.elastic.sailor.FunctionBuilder;
import io.elastic.sailor.Step;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FunctionBuilderImpl
implements FunctionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(FunctionBuilderImpl.class);
    private final ComponentDescriptorResolver componentDescriptorResolver;
    private final Step step;

    @Inject
    public FunctionBuilderImpl(ComponentDescriptorResolver componentDescriptorResolver, @Named(value="StepJson") Step step) {
        this.componentDescriptorResolver = componentDescriptorResolver;
        this.step = step;
    }

    @Override
    public Function build() {
        String module = this.step.getFunction();
        String className = this.componentDescriptorResolver.findModule(module);
        logger.info("Function Java class to be instantiated: {}", (Object)className);
        try {
            return this.newComponent(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Function newComponent(String componentClassName) throws Exception {
        logger.info("Instantiating component {}", (Object)componentClassName);
        Class<?> clazz = Class.forName(componentClassName);
        return (Function)clazz.cast(clazz.newInstance());
    }
}

