/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.elastic.api.JSON;
import io.elastic.api.Message;
import io.elastic.sailor.AmqpService;
import io.elastic.sailor.ExecutionContext;
import io.elastic.sailor.impl.CountingCallbackImpl;
import io.elastic.sailor.impl.CryptoServiceImpl;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCallback
extends CountingCallbackImpl {
    private static final Logger logger = LoggerFactory.getLogger(DataCallback.class);
    private AmqpService amqp;
    private CryptoServiceImpl cipher;
    private ExecutionContext executionContext;

    @Inject
    public DataCallback(@Assisted ExecutionContext executionContext, AmqpService amqp, CryptoServiceImpl cipher) {
        this.executionContext = executionContext;
        this.amqp = amqp;
        this.cipher = cipher;
    }

    @Override
    public void receiveData(Object data) {
        logger.info("Step produced data to be published");
        Message message = (Message)data;
        JsonObject messageAsJson = this.executionContext.createPublisheableMessage(message);
        byte[] encryptedPayload = this.cipher.encrypt(JSON.stringify(messageAsJson)).getBytes();
        this.amqp.sendData(encryptedPayload, this.executionContext.buildAmqpProperties(message.getId()));
    }
}

