/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.elastic.api.JSON;
import io.elastic.api.Message;
import io.elastic.sailor.Utils;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(CryptoServiceImpl.class);
    private final String ALGORITHM = "AES/CBC/PKCS5Padding";
    private Key encryptionKey;
    private IvParameterSpec encryptionIV;

    @Inject
    public CryptoServiceImpl(@Named(value="ELASTICIO_MESSAGE_CRYPTO_PASSWORD") String password, @Named(value="ELASTICIO_MESSAGE_CRYPTO_IV") String initializationVector) {
        Preconditions.checkNotNull((Object)password, (Object)"ELASTICIO_MESSAGE_CRYPTO_PASSWORD is required");
        Preconditions.checkNotNull((Object)initializationVector, (Object)"ELASTICIO_MESSAGE_CRYPTO_IV is required");
        this.encryptionKey = this.generateKey(password);
        this.encryptionIV = new IvParameterSpec(initializationVector.getBytes());
    }

    public String encryptMessage(Message message) {
        return this.encrypt(message.toString());
    }

    public String encryptJsonObject(JsonObject message) {
        return this.encrypt(message.toString());
    }

    public JsonObject decryptMessageContent(String message) {
        if (message == null || message.isEmpty()) {
            logger.info("Message is null or empty. Returning empty JSON object");
            return Json.createObjectBuilder().build();
        }
        String decryptedMessage = this.decrypt(message);
        if (Utils.isJsonObject(decryptedMessage)) {
            logger.info("Parsing message JSON");
            return JSON.parseObject(decryptedMessage);
        }
        throw new RuntimeException("Message is not a JSON object: " + decryptedMessage);
    }

    public String encrypt(String message) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, this.encryptionKey, this.encryptionIV);
            byte[] a = cipher.doFinal(message.getBytes());
            return new String(Base64.encodeBase64((byte[])a));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String decrypt(String message) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, this.encryptionKey, this.encryptionIV);
            byte[] messageBytes = cipher.doFinal(Base64.decodeBase64((byte[])message.getBytes()));
            return new String(messageBytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Key generateKey(String encryptionKey) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] key = md.digest(encryptionKey.getBytes("UTF-8"));
            return new SecretKeySpec(key, "AES");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

