/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.contrib.json.classic.JsonLayout;
import io.elastic.sailor.ContainerContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.MDC;

public class BunyanJsonLayout
extends JsonLayout {
    public static final String LEVEL = "level";
    public static final String LEVEL_STRING = "level_str";
    public static final String TIME = "time";
    public static final String HOSTNAME = "hostname";
    public static final String THREAD_ID = "threadId";
    public static final String MESSAGE_ID = "messageId";
    public static final String PARENT_MESSAGE_ID = "parentMessageId";
    public static final String MESSAGE = "msg";
    private static int BUNYAN_LEVEL_TRACE = 10;
    private static int BUNYAN_LEVEL_DEBUG = 20;
    private static int BUNYAN_LEVEL_INFO = 30;
    private static int BUNYAN_LEVEL_WARN = 40;
    private static int BUNYAN_LEVEL_ERROR = 50;
    public static ContainerContext containerContext;

    protected void addCustomDataToJsonMap(Map<String, Object> map, ILoggingEvent event) {
        super.addCustomDataToJsonMap(map, event);
        String time = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
        String threadId = MDC.get((String)THREAD_ID);
        String messageId = MDC.get((String)MESSAGE_ID);
        String parentMessageId = MDC.get((String)PARENT_MESSAGE_ID);
        this.putFromContainerContext(map);
        if (threadId != null) {
            map.put(THREAD_ID, threadId);
        }
        if (messageId != null) {
            map.put(MESSAGE_ID, messageId);
        }
        if (parentMessageId != null) {
            map.put(PARENT_MESSAGE_ID, parentMessageId);
        }
        map.put(LEVEL, this.getBunyanLevel(event));
        map.put(LEVEL_STRING, event.getLevel().levelStr);
        map.put(TIME, time);
        map.remove("timestamp");
        Object message = map.get("message");
        map.put(MESSAGE, message);
        map.remove("message");
        try {
            map.put(HOSTNAME, InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
    }

    private void putFromContainerContext(Map<String, Object> map) {
        if (containerContext == null) {
            return;
        }
        map.put("ELASTICIO_CONTAINER_ID", containerContext.getContainerId());
        map.put("ELASTICIO_API_USERNAME", containerContext.getApiUserName());
        map.put("ELASTICIO_COMP_NAME", containerContext.getComponentName());
        map.put("ELASTICIO_CONTRACT_ID", containerContext.getContractId());
        map.put("ELASTICIO_EXEC_TYPE", containerContext.getExecType());
        map.put("ELASTICIO_EXECUTION_RESULT_ID", containerContext.getExecResultId());
        map.put("ELASTICIO_FLOW_VERSION", containerContext.getFlowVersion());
        map.put("ELASTICIO_TASK_USER_EMAIL", containerContext.getFlowUserEmail());
        map.put("ELASTICIO_TENANT_ID", containerContext.getTenantId());
        map.put("ELASTICIO_WORKSPACE_ID", containerContext.getWorkspaceId());
    }

    public int getBunyanLevel(ILoggingEvent event) {
        Level level = event.getLevel();
        if (level == Level.TRACE) {
            return BUNYAN_LEVEL_TRACE;
        }
        if (level == Level.DEBUG) {
            return BUNYAN_LEVEL_DEBUG;
        }
        if (level == Level.INFO) {
            return BUNYAN_LEVEL_INFO;
        }
        if (level == Level.WARN) {
            return BUNYAN_LEVEL_WARN;
        }
        if (level == Level.ERROR) {
            return BUNYAN_LEVEL_ERROR;
        }
        return BUNYAN_LEVEL_INFO;
    }
}

