/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.elastic.sailor.ApiClient;
import io.elastic.sailor.Step;
import io.elastic.sailor.impl.HttpUtils;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApiClientImpl
implements ApiClient {
    private static final Logger logger = LoggerFactory.getLogger((String)ApiClientImpl.class.getName());
    private final String apiUser;
    private final String apiKey;
    private final String apiBaseUri;
    private final int retryCount;
    private boolean putIncomingMessageIntoPassThrough;

    @Inject
    public ApiClientImpl(@Named(value="ELASTICIO_API_URI") String apiUri, @Named(value="ELASTICIO_API_USERNAME") String apiUser, @Named(value="ELASTICIO_API_KEY") String apiKey, @Named(value="ELASTICIO_API_REQUEST_RETRY_ATTEMPTS") int retryCount, @Named(value="ELASTICIO_NO_SELF_PASSTRHOUGH") boolean putIncomingMessageIntoPassThrough) {
        this.apiUser = apiUser;
        this.apiKey = apiKey;
        this.apiBaseUri = String.format("%s", apiUri);
        this.retryCount = retryCount;
        this.putIncomingMessageIntoPassThrough = putIncomingMessageIntoPassThrough;
    }

    @Override
    public Step retrieveFlowStep(String taskId, String stepId) {
        String uri = String.format("%s/v1/tasks/%s/steps/%s", this.apiBaseUri, taskId, stepId);
        logger.info("Retrieving step data for user {} at: {}", (Object)this.apiUser, (Object)uri);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.apiUser, this.apiKey);
        JsonObject step = HttpUtils.getJson(uri, credentials, this.retryCount);
        return new Step(step, this.putIncomingMessageIntoPassThrough);
    }

    @Override
    public JsonObject updateAccount(String accountId, JsonObject body) {
        String uri = String.format("%s/v1/accounts/%s", this.apiBaseUri, accountId);
        logger.info("Updating account for user {} at: {}", (Object)this.apiUser, (Object)uri);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.apiUser, this.apiKey);
        return HttpUtils.putJson(uri, body, credentials, this.retryCount);
    }

    @Override
    public void storeStartupState(String flowId, JsonObject body) {
        String uri = this.getStartupStateUrl(flowId);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.apiUser, this.apiKey);
        HttpUtils.postJson(uri, body, credentials, this.retryCount);
    }

    @Override
    public JsonObject retrieveStartupState(String flowId) {
        UsernamePasswordCredentials credentials;
        String uri = this.getStartupStateUrl(flowId);
        JsonObject state = HttpUtils.getJson(uri, credentials = new UsernamePasswordCredentials(this.apiUser, this.apiKey), this.retryCount);
        if (state == null) {
            return Json.createObjectBuilder().build();
        }
        return state;
    }

    @Override
    public void deleteStartupState(String flowId) {
        String uri = this.getStartupStateUrl(flowId);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.apiUser, this.apiKey);
        HttpUtils.delete(uri, credentials, this.retryCount);
    }

    private String getStartupStateUrl(String flowId) {
        return String.format("%s/sailor-support/hooks/task/%s/startup/data", this.apiBaseUri, flowId);
    }
}

