/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import javax.json.Json;
import javax.json.JsonObject;

public class ServiceExecutionParameters {
    private final String className;
    private final JsonObject configuration;
    private final JsonObject triggerOrAction;
    private final String modelClassName;
    private final String credentialsVerifierClassName;

    private ServiceExecutionParameters(String componentClassName, JsonObject configuration, JsonObject triggerOrAction, String modelClassName, String credentialsVerifierClassName) {
        this.className = componentClassName;
        this.configuration = configuration;
        this.triggerOrAction = triggerOrAction;
        this.modelClassName = modelClassName;
        this.credentialsVerifierClassName = credentialsVerifierClassName;
    }

    public String getClassName() {
        return this.className;
    }

    public JsonObject getConfiguration() {
        return this.configuration;
    }

    public JsonObject getTriggerOrAction() {
        return this.triggerOrAction;
    }

    public String getModelClassName() {
        return this.modelClassName;
    }

    public String getCredentialsVerifierClassName() {
        return this.credentialsVerifierClassName;
    }

    public static final class Builder {
        private String componentClassName;
        private JsonObject configuration = Json.createObjectBuilder().build();
        private JsonObject triggerOrAction;
        private String modelClassName;
        private String credentialsVerifierClassName;

        public Builder className(String value) {
            this.componentClassName = value;
            return this;
        }

        public Builder configuration(JsonObject configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder triggerOrAction(JsonObject value) {
            this.triggerOrAction = value;
            return this;
        }

        public Builder modelClassName(String value) {
            this.modelClassName = value;
            return this;
        }

        public Builder credentialsVerifierClassName(String value) {
            this.credentialsVerifierClassName = value;
            return this;
        }

        public ServiceExecutionParameters build() {
            return new ServiceExecutionParameters(this.componentClassName, this.configuration, this.triggerOrAction, this.modelClassName, this.credentialsVerifierClassName);
        }
    }
}

