/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import io.elastic.sailor.Utils;
import java.lang.annotation.Annotation;

public class ServiceEnvironmentModule
extends AbstractModule {
    protected void configure() {
        this.bindEnvVars();
    }

    void bindEnvVars() {
        this.bindRequiredStringEnvVar("ELASTICIO_CFG");
        this.bindRequiredStringEnvVar("ELASTICIO_POST_RESULT_URL");
        this.bindOptionalStringEnvVar("ELASTICIO_ACTION_OR_TRIGGER");
        this.bindOptionalStringEnvVar("ELASTICIO_GET_MODEL_METHOD");
        this.bindOptionalIntegerEnvVar("ELASTICIO_API_REQUEST_RETRY_ATTEMPTS", 3);
    }

    void bindRequiredStringEnvVar(String name) {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)Utils.getEnvVar(name));
    }

    void bindOptionalStringEnvVar(final String name) {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new Provider<String>(){

            public String get() {
                return Utils.getOptionalEnvVar(name);
            }
        });
    }

    private static int getOptionalIntegerValue(String key, int defaultValue) {
        String value = Utils.getOptionalEnvVar(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    void bindOptionalIntegerEnvVar(String name, int defaultValue) {
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)ServiceEnvironmentModule.getOptionalIntegerValue(name, defaultValue));
    }
}

