/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.elastic.sailor.ApiClient;
import io.elastic.sailor.ContainerContext;
import io.elastic.sailor.FunctionBuilder;
import io.elastic.sailor.Step;
import io.elastic.sailor.impl.ApiClientImpl;
import io.elastic.sailor.impl.FunctionBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailorModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger((String)SailorModule.class.getName());

    protected void configure() {
        this.bind(ApiClient.class).to(ApiClientImpl.class);
        this.bind(FunctionBuilder.class).to(FunctionBuilderImpl.class);
    }

    @Provides
    @Singleton
    @Named(value="StepJson")
    Step provideTask(ApiClient apiClient, ContainerContext ctx) {
        return apiClient.retrieveFlowStep(ctx.getFlowId(), ctx.getStepId());
    }
}

