/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import io.elastic.sailor.Utils;
import java.lang.annotation.Annotation;

public class SailorEnvironmentModule
extends AbstractModule {
    protected void configure() {
        this.bindEnvVars();
    }

    void bindEnvVars() {
        this.bindRequiredStringEnvVar("ELASTICIO_API_URI");
        this.bindRequiredStringEnvVar("ELASTICIO_API_USERNAME");
        this.bindRequiredStringEnvVar("ELASTICIO_API_KEY");
        this.bindRequiredStringEnvVar("ELASTICIO_FLOW_ID");
        this.bindRequiredStringEnvVar("ELASTICIO_STEP_ID");
        this.bindRequiredStringEnvVar("ELASTICIO_FUNCTION");
        this.bindRequiredStringEnvVar("ELASTICIO_EXEC_ID");
        this.bindRequiredStringEnvVar("ELASTICIO_USER_ID");
        this.bindRequiredStringEnvVar("ELASTICIO_COMP_ID");
        this.bindRequiredStringEnvVar("ELASTICIO_CONTAINER_ID");
        this.bindRequiredStringEnvVar("ELASTICIO_WORKSPACE_ID");
        this.bindOptionalStringEnvVar("ELASTICIO_COMP_NAME");
        this.bindOptionalStringEnvVar("ELASTICIO_CONTRACT_ID");
        this.bindOptionalStringEnvVar("ELASTICIO_EXEC_TYPE");
        this.bindOptionalStringEnvVar("ELASTICIO_EXECUTION_RESULT_ID");
        this.bindOptionalStringEnvVar("ELASTICIO_FLOW_VERSION");
        this.bindOptionalStringEnvVar("ELASTICIO_TASK_USER_EMAIL");
        this.bindOptionalStringEnvVar("ELASTICIO_TENANT_ID");
        this.bindOptionalStringEnvVar("ELASTICIO_WORKSPACE_ID");
        this.bindOptionalIntegerEnvVar("ELASTICIO_REBOUND_LIMIT", 20);
        this.bindOptionalIntegerEnvVar("ELASTICIO_REBOUND_INITIAL_EXPIRATION", 15000);
        this.bindOptionalIntegerEnvVar("ELASTICIO_RABBITMQ_PREFETCH_SAILOR", 1);
        this.bindOptionalIntegerEnvVar("ELASTICIO_API_REQUEST_RETRY_ATTEMPTS", 3);
        this.bindOptionalYesNoEnvVar("ELASTICIO_STARTUP_REQUIRED");
        this.bindOptionalYesNoEnvVar("ELASTICIO_NO_SELF_PASSTRHOUGH");
        this.bindOptionalYesNoEnvVar("ELASTICIO_HOOK_SHUTDOWN");
    }

    void bindRequiredStringEnvVar(String name) {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)Utils.getEnvVar(name));
    }

    void bindOptionalStringEnvVar(String name) {
        String value = Utils.getOptionalEnvVar(name);
        if (value == null) {
            return;
        }
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)value);
    }

    void bindOptionalIntegerEnvVar(String name, int defaultValue) {
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)SailorEnvironmentModule.getOptionalIntegerValue(name, defaultValue));
    }

    void bindOptionalYesNoEnvVar(String name) {
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)SailorEnvironmentModule.getOptionalYesNoValue(name));
    }

    private static int getOptionalIntegerValue(String key, int defaultValue) {
        String value = Utils.getOptionalEnvVar(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    private static boolean getOptionalYesNoValue(String key) {
        String value = Utils.getOptionalEnvVar(key);
        return value != null;
    }
}

