/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentDescriptorResolver {
    private static final Logger logger = LoggerFactory.getLogger(ComponentDescriptorResolver.class);
    private static final String FILENAME = "/component.json";
    private final JsonObject componentJson = ComponentDescriptorResolver.loadComponentJson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObject loadComponentJson() {
        logger.info("Component descriptor from classpath: {}", (Object)FILENAME);
        InputStream stream = ComponentDescriptorResolver.class.getResourceAsStream(FILENAME);
        if (stream == null) {
            throw new IllegalStateException(String.format("Component descriptor %s is not found in the classpath", FILENAME));
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(stream);
            JsonObject jsonObject = Json.createReader((Reader)reader).readObject();
            return jsonObject;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close reader", (Throwable)e);
                }
            }
        }
    }

    public String findCredentialsVerifier() {
        JsonObject credentials = this.componentJson.getJsonObject("credentials");
        if (credentials == null) {
            return null;
        }
        JsonString verifier = credentials.getJsonString("verifier");
        if (verifier == null) {
            return null;
        }
        return verifier.getString();
    }

    public String findModule(String name) {
        JsonObject object = this.findModuleObject(name);
        JsonString main = object.getJsonString("main");
        if (main == null) {
            throw new RuntimeException("Main class of '" + name + "' trigger/action is not specified");
        }
        return main.getString();
    }

    public JsonObject findModuleObject(String name) {
        JsonObject result = null;
        JsonObject triggers = this.componentJson.getJsonObject("triggers");
        JsonObject actions = this.componentJson.getJsonObject("actions");
        if (triggers != null && triggers.get((Object)name) != null) {
            result = triggers.getJsonObject(name);
        }
        if (actions != null && actions.get((Object)name) != null) {
            result = actions.getJsonObject(name);
        }
        if (result == null) {
            throw new RuntimeException("'" + name + "' trigger or action is not found");
        }
        return result;
    }
}

