/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import com.rabbitmq.client.AMQP;
import io.elastic.api.Message;
import io.elastic.sailor.AMQPWrapperInterface;
import io.elastic.sailor.CipherWrapper;
import io.elastic.sailor.ExecutionContext;
import io.elastic.sailor.impl.CountingCallbackImpl;
import java.util.Map;

public class ReboundCallback
extends CountingCallbackImpl {
    private ExecutionContext executionContext;
    private AMQPWrapperInterface amqp;
    private CipherWrapper cipher;
    private Integer reboundLimit;
    private Integer reboundInitialExpiration;

    @Inject
    public ReboundCallback(@Assisted ExecutionContext executionContext, AMQPWrapperInterface amqp, CipherWrapper cipher, @Named(value="REBOUND_LIMIT") Integer reboundLimit, @Named(value="REBOUND_INITIAL_EXPIRATION") Integer reboundInitialExpiration) {
        this.executionContext = executionContext;
        this.amqp = amqp;
        this.cipher = cipher;
        this.reboundLimit = reboundLimit;
        this.reboundInitialExpiration = reboundInitialExpiration;
    }

    @Override
    public void receiveData(Object data) {
        int reboundIteration = this.getReboundIteration();
        if (reboundIteration > this.reboundLimit) {
            throw new RuntimeException("Rebound limit exceeded");
        }
        Message message = this.executionContext.getMessage();
        byte[] payload = this.cipher.encryptMessage(message).getBytes();
        Map<String, Object> headers = this.executionContext.buildDefaultHeaders();
        headers.put("reboundReason", data.toString());
        headers.put("reboundIteration", reboundIteration);
        double expiration = this.getReboundExpiration(reboundIteration);
        this.amqp.sendRebound(payload, this.makeReboundOptions(headers, expiration));
    }

    private int getReboundIteration() {
        Map<String, Object> headers = this.executionContext.getHeaders();
        Object reboundIteration = headers.get("reboundIteration");
        if (reboundIteration != null) {
            try {
                return Integer.parseInt(reboundIteration.toString()) + 1;
            }
            catch (Exception e) {
                throw new RuntimeException("Not a number in reboundIteration header: " + reboundIteration);
            }
        }
        return 1;
    }

    private double getReboundExpiration(int reboundIteration) {
        return Math.pow(2.0, reboundIteration - 1) * (double)this.reboundInitialExpiration.intValue();
    }

    private AMQP.BasicProperties makeReboundOptions(Map<String, Object> headers, double expiration) {
        return new AMQP.BasicProperties.Builder().contentType("application/json").contentEncoding("utf8").expiration(Double.toString(expiration)).headers(headers).build();
    }
}

