/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor.impl;

import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.elastic.api.EventEmitter;
import io.elastic.api.ExecutionParameters;
import io.elastic.api.Executor;
import io.elastic.api.Message;
import io.elastic.sailor.ComponentResolver;
import io.elastic.sailor.CountingCallback;
import io.elastic.sailor.EmitterCallbackFactory;
import io.elastic.sailor.ExecutionContext;
import io.elastic.sailor.ExecutionStats;
import io.elastic.sailor.MessageProcessor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageProcessorImpl
implements MessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MessageProcessorImpl.class);
    private final ComponentResolver componentResolver;
    private final EmitterCallbackFactory emitterCallbackFactory;
    private final JsonObject task;
    private final String stepId;

    @Inject
    public MessageProcessorImpl(ComponentResolver componentResolver, EmitterCallbackFactory emitterCallbackFactory, @Named(value="TaskJson") JsonObject task, @Named(value="STEP_ID") String stepId) {
        this.componentResolver = componentResolver;
        this.emitterCallbackFactory = emitterCallbackFactory;
        this.task = task;
        this.stepId = stepId;
    }

    @Override
    public ExecutionStats processMessage(Message incomingMessage, Map<String, Object> incomingHeaders, Long deliveryTag) {
        ExecutionContext executionContext = new ExecutionContext(this.stepId, this.task, incomingMessage, incomingHeaders);
        logger.info("Processing step '{}' of a task", (Object)executionContext.getStepId());
        String triggerOrAction = executionContext.getFunction();
        String className = this.componentResolver.findTriggerOrAction(triggerOrAction);
        JsonObject cfg = executionContext.getCfg();
        JsonObject snapshot = executionContext.getSnapshot();
        logger.info("Component to be executed: {}", (Object)executionContext.getCompId());
        logger.info("Trigger/action to be executed: {}", (Object)executionContext.getTriggerOrAction());
        logger.info("Component Java class to be instantiated: {}", (Object)className);
        ExecutionParameters params = new ExecutionParameters.Builder(incomingMessage).configuration(cfg).snapshot(snapshot).build();
        CountingCallback dataCallback = this.emitterCallbackFactory.createDataCallback(executionContext);
        CountingCallback errorCallback = this.emitterCallbackFactory.createErrorCallback(executionContext);
        CountingCallback reboundCallback = this.emitterCallbackFactory.createReboundCallback(executionContext);
        CountingCallback snapshotCallback = this.emitterCallbackFactory.createSnapshotCallback(executionContext);
        EventEmitter eventEmitter = new EventEmitter.Builder().onData((EventEmitter.Callback)dataCallback).onError((EventEmitter.Callback)errorCallback).onRebound((EventEmitter.Callback)reboundCallback).onSnapshot((EventEmitter.Callback)snapshotCallback).build();
        Executor executor = new Executor(className, eventEmitter);
        executor.execute(params);
        return new ExecutionStats(dataCallback.getCount(), errorCallback.getCount(), reboundCallback.getCount());
    }
}

