/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    private static final Logger logger = LoggerFactory.getLogger((String)Utils.class.getName());

    Utils() {
    }

    public static boolean isJsonObject(String input) {
        try {
            new Gson().fromJson(input, Object.class);
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    public static boolean isJsonObject(JsonElement element) {
        return element != null && element.isJsonObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postJson(String url, JsonObject body) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(body.toString()));
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            Utils.auth((HttpRequest)httpPost, url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null) {
                throw new RuntimeException("Null response received");
            }
            String result = EntityUtils.toString((HttpEntity)responseEntity);
            EntityUtils.consume((HttpEntity)responseEntity);
            logger.info("Successfully posted json {} bytes length", (Object)body.toString().length());
            String string = result;
            return string;
        }
        finally {
            httpClient.close();
        }
    }

    private static void auth(HttpRequest request, String url) throws IOException {
        URL aURL = new URL(url);
        String userInfo = aURL.getUserInfo();
        if (userInfo == null) {
            throw new IllegalArgumentException("User info is missing in the given url: " + url);
        }
        String decodedUserInfo = URLDecoder.decode(userInfo, "UTF-8");
        String[] userAndPassword = decodedUserInfo.split(":");
        if (userAndPassword.length != 2) {
            throw new IllegalArgumentException("Either username or password is missing");
        }
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userAndPassword[0], userAndPassword[1]);
        try {
            Header header = new BasicScheme().authenticate((Credentials)credentials, request, null);
            request.addHeader(header);
        }
        catch (AuthenticationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getEnvVar(String key) {
        String value = Utils.getOptionalEnvVar(key);
        if (value == null) {
            throw new IllegalStateException(String.format("Env var '%s' is required", key));
        }
        return value;
    }

    public static String getOptionalEnvVar(String key) {
        String value = System.getenv(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }
}

