/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import io.elastic.sailor.Utils;
import java.lang.annotation.Annotation;

public class ServiceEnvironmentModule
extends AbstractModule {
    protected void configure() {
        this.bindEnvVars();
    }

    void bindEnvVars() {
        this.bindRequiredStringEnvVar("CFG");
        this.bindRequiredStringEnvVar("POST_RESULT_URL");
        this.bindOptionalStringEnvVar("ACTION_OR_TRIGGER");
        this.bindOptionalStringEnvVar("GET_MODEL_METHOD");
    }

    void bindRequiredStringEnvVar(String name) {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)Utils.getEnvVar(name));
    }

    void bindOptionalStringEnvVar(final String name) {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new Provider<String>(){

            public String get() {
                return Utils.getOptionalEnvVar(name);
            }
        });
    }
}

