/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.elastic.sailor.ComponentResolver;
import io.elastic.sailor.ServiceEnvironmentModule;
import io.elastic.sailor.ServiceExecutionParameters;
import io.elastic.sailor.ServiceMethods;
import io.elastic.sailor.ServiceModule;
import io.elastic.sailor.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service {
    private static final Logger logger = LoggerFactory.getLogger((String)Service.class.getName());
    private final String postResultUrl;
    private final ServiceExecutionParameters params;

    @Inject
    public Service(ComponentResolver resolver, @Named(value="POST_RESULT_URL") String postResultUrl, @Named(value="ConfigurationJson") JsonObject configuration, @Named(value="ACTION_OR_TRIGGER") Provider<String> triggerOrActionProvider, @Named(value="GET_MODEL_METHOD") Provider<String> metaModelName) {
        this.postResultUrl = postResultUrl;
        String triggerOrAction = (String)triggerOrActionProvider.get();
        JsonObject triggerOrActionObj = null;
        if (triggerOrAction != null) {
            triggerOrActionObj = resolver.findTriggerOrActionObject(triggerOrAction).getAsJsonObject();
        }
        this.params = new ServiceExecutionParameters.Builder().configuration(configuration).triggerOrAction(triggerOrActionObj).modelClassName((String)metaModelName.get()).credentialsVerifierClassName(resolver.findCredentialsVerifier()).build();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            throw new IllegalArgumentException("1 argument is required, but were passed " + args.length);
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new ServiceModule(), new ServiceEnvironmentModule()});
        String methodName = args[0];
        logger.info("Starting execution of {}", (Object)methodName);
        ServiceMethods method = ServiceMethods.parse(methodName);
        Service.getServiceInstanceAndExecute(method, injector);
    }

    public static void getServiceInstanceAndExecute(ServiceMethods method, Injector injector) {
        Service service = (Service)injector.getInstance(Service.class);
        try {
            service.executeMethod(method);
        }
        catch (Exception e) {
            service.processException(e);
        }
    }

    private void createResponseAndSend(String status, JsonObject data) {
        JsonObject payload = new JsonObject();
        payload.addProperty("status", status);
        payload.add("data", (JsonElement)data);
        Service.sendData(this.postResultUrl, payload);
    }

    public void executeMethod(ServiceMethods method) {
        JsonObject data = method.execute(this.params);
        this.createResponseAndSend("success", data);
    }

    private void processException(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        JsonObject data = new JsonObject();
        data.addProperty("message", writer.toString());
        this.createResponseAndSend("error", data);
    }

    private static void sendData(String url, JsonObject payload) {
        logger.info("Sending response");
        try {
            String response = Utils.postJson(url, payload);
            logger.info("Received response from server: {}", (Object)response.toString());
        }
        catch (IOException e) {
            logger.info("Failed to send response: {}", (Object)e.getMessage());
        }
    }
}

