/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.elastic.sailor.AMQPWrapper;
import io.elastic.sailor.AMQPWrapperInterface;
import io.elastic.sailor.CountingCallback;
import io.elastic.sailor.EmitterCallbackFactory;
import io.elastic.sailor.MessageProcessor;
import io.elastic.sailor.impl.DataCallback;
import io.elastic.sailor.impl.ErrorCallback;
import io.elastic.sailor.impl.MessageProcessorImpl;
import io.elastic.sailor.impl.ReboundCallback;
import io.elastic.sailor.impl.SnapshotCallback;
import java.lang.annotation.Annotation;

public class SailorModule
extends AbstractModule {
    protected void configure() {
        this.bind(AMQPWrapperInterface.class).to(AMQPWrapper.class);
        this.bind(MessageProcessor.class).to(MessageProcessorImpl.class);
        this.install(new FactoryModuleBuilder().implement(CountingCallback.class, (Annotation)Names.named((String)"dataCallback"), DataCallback.class).implement(CountingCallback.class, (Annotation)Names.named((String)"errorCallback"), ErrorCallback.class).implement(CountingCallback.class, (Annotation)Names.named((String)"snapshotCallback"), SnapshotCallback.class).implement(CountingCallback.class, (Annotation)Names.named((String)"reboundCallback"), ReboundCallback.class).build(EmitterCallbackFactory.class));
    }

    @Provides
    @Named(value="TaskJson")
    JsonObject provideTask(@Named(value="TASK") String task) {
        return new JsonParser().parse(task).getAsJsonObject();
    }

    @Provides
    @Named(value="ConfigurationJson")
    JsonObject provideConfiguration(@Named(value="STEP_ID") String stepId, @Named(value="TaskJson") JsonObject task) {
        JsonElement data = task.get("data");
        if (data == null) {
            throw new IllegalStateException("Property 'data' is missing in task's JSON");
        }
        JsonElement stepData = data.getAsJsonObject().get(stepId);
        if (stepData == null) {
            throw new IllegalStateException("No configuration provided for step:" + stepId);
        }
        return stepData.getAsJsonObject();
    }
}

