/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import io.elastic.sailor.Utils;
import java.lang.annotation.Annotation;

public class SailorEnvironmentModule
extends AbstractModule {
    protected void configure() {
        this.bindEnvVars();
    }

    void bindEnvVars() {
        this.bindRequiredStringEnvVar("MESSAGE_CRYPTO_PASSWORD");
        this.bindRequiredStringEnvVar("MESSAGE_CRYPTO_IV");
        this.bindRequiredStringEnvVar("TASK");
        this.bindRequiredStringEnvVar("STEP_ID");
        this.bindRequiredStringEnvVar("FUNCTION");
        this.bindRequiredStringEnvVar("AMQP_URI");
        this.bindRequiredStringEnvVar("LISTEN_MESSAGES_ON");
        this.bindRequiredStringEnvVar("PUBLISH_MESSAGES_TO");
        this.bindRequiredStringEnvVar("DATA_ROUTING_KEY");
        this.bindRequiredStringEnvVar("ERROR_ROUTING_KEY");
        this.bindRequiredStringEnvVar("REBOUND_ROUTING_KEY");
        this.bindRequiredStringEnvVar("SNAPSHOT_ROUTING_KEY");
        this.bindOptionalIntegerEnvVar("REBOUND_LIMIT", 20);
        this.bindOptionalIntegerEnvVar("REBOUND_INITIAL_EXPIRATION", 15000);
    }

    void bindRequiredStringEnvVar(String name) {
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)Utils.getEnvVar(name));
    }

    void bindOptionalIntegerEnvVar(String name, int defaultValue) {
        this.bind(Integer.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)SailorEnvironmentModule.getOptionalIntegerValue(name, defaultValue));
    }

    private static int getOptionalIntegerValue(String key, int defaultValue) {
        String value = Utils.getOptionalEnvVar(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }
}

