/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.elastic.sailor.AMQPWrapperInterface;
import io.elastic.sailor.SailorEnvironmentModule;
import io.elastic.sailor.SailorModule;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sailor {
    private static final Logger logger = LoggerFactory.getLogger(Sailor.class);
    private AMQPWrapperInterface amqp;

    public static void main(String[] args) throws IOException {
        logger.info("Sailor started");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SailorModule(), new SailorEnvironmentModule()});
        Sailor sailor = (Sailor)injector.getInstance(Sailor.class);
        sailor.start();
    }

    @Inject
    public void setAMQP(AMQPWrapperInterface amqp) {
        this.amqp = amqp;
    }

    public void start() throws IOException {
        logger.info("Connecting to AMQP");
        this.amqp.connect();
        logger.info("Subscribing to queues");
        this.amqp.subscribeConsumer();
    }
}

