/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import io.elastic.api.Message;
import io.elastic.sailor.CipherWrapper;
import io.elastic.sailor.ExecutionStats;
import io.elastic.sailor.MessageProcessor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageConsumer
extends DefaultConsumer {
    private static final Logger logger = LoggerFactory.getLogger(MessageConsumer.class);
    private final CipherWrapper cipher;
    private final MessageProcessor processor;

    public MessageConsumer(Channel channel, CipherWrapper cipher, MessageProcessor processor) {
        super(channel);
        this.cipher = cipher;
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        Message message;
        long deliveryTag = envelope.getDeliveryTag();
        logger.info("Consumer {} received message {}", (Object)consumerTag, (Object)deliveryTag);
        try {
            String bodyString = new String(body, "UTF-8");
            message = this.cipher.decryptMessage(bodyString);
        }
        catch (Exception e) {
            logger.info("Failed to decrypt message {}: {}", (Object)deliveryTag, (Object)e.getMessage());
            this.getChannel().basicReject(deliveryTag, false);
            return;
        }
        ExecutionStats stats = null;
        try {
            stats = this.processor.processMessage(message, properties.getHeaders(), deliveryTag);
        }
        catch (Exception e) {
            try {
                logger.info("Failed to process message {}: {}", (Object)deliveryTag, (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                this.ackOrReject(stats, deliveryTag);
                throw throwable;
            }
            this.ackOrReject(stats, deliveryTag);
        }
        this.ackOrReject(stats, deliveryTag);
    }

    private void ackOrReject(ExecutionStats stats, long deliveryTag) throws IOException {
        logger.info("Execution stats: {}", (Object)stats);
        if (stats == null || stats.getErrorCount() > 0) {
            logger.info("Reject received messages {}", (Object)deliveryTag);
            this.getChannel().basicReject(deliveryTag, false);
            return;
        }
        logger.info("Acknowledging received messages {}", (Object)deliveryTag);
        this.getChannel().basicAck(deliveryTag, true);
    }
}

