/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rabbitmq.client.AMQP;
import io.elastic.api.Message;
import java.util.HashMap;
import java.util.Map;

public class ExecutionContext {
    private final String stepId;
    private final JsonObject task;
    private final Message message;
    private final Map<String, Object> headers;

    public ExecutionContext(String stepId, JsonObject task, Message message, Map<String, Object> headers) {
        this.stepId = stepId;
        this.task = task;
        this.message = message;
        this.headers = headers;
    }

    public String getStepId() {
        return this.stepId;
    }

    public String getCompId() {
        return this.getTriggerOrAction().get("compId").getAsString();
    }

    public String getFunction() {
        return this.getTriggerOrAction().get("function").getAsString();
    }

    public JsonObject getTriggerOrAction() {
        String stepId = this.getStepId();
        JsonArray nodes = this.task.getAsJsonObject("recipe").getAsJsonArray("nodes");
        JsonObject thisStepNode = null;
        for (JsonElement node : nodes) {
            if (!node.getAsJsonObject().get("id").getAsString().equals(stepId)) continue;
            thisStepNode = node.getAsJsonObject();
        }
        if (thisStepNode == null) {
            throw new RuntimeException("Step " + stepId + " is not found in task recipe");
        }
        if (thisStepNode.get("function") == null) {
            throw new RuntimeException("Step " + stepId + " has no function specified");
        }
        return thisStepNode;
    }

    public JsonObject getCfg() {
        String stepId = this.getStepId();
        if (this.task.get("data") != null && this.task.getAsJsonObject("data").get(stepId) != null) {
            return this.task.getAsJsonObject("data").getAsJsonObject(stepId);
        }
        return new JsonObject();
    }

    public JsonObject getSnapshot() {
        String stepId = this.getStepId();
        if (this.task.get("snapshot") != null && this.task.getAsJsonObject("snapshot").get(stepId) != null) {
            return this.task.getAsJsonObject("snapshot").getAsJsonObject(stepId);
        }
        return new JsonObject();
    }

    public Map<String, Object> buildDefaultHeaders() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("execId", this.headers.get("execId"));
        result.put("taskId", this.headers.get("taskId"));
        result.put("userId", this.headers.get("userId"));
        result.put("stepId", this.getStepId());
        result.put("compId", this.getCompId());
        result.put("function", this.getFunction());
        result.put("start", System.currentTimeMillis());
        return result;
    }

    public AMQP.BasicProperties buildDefaultOptions() {
        return new AMQP.BasicProperties.Builder().contentType("application/json").contentEncoding("utf8").headers(this.buildDefaultHeaders()).priority(Integer.valueOf(1)).deliveryMode(Integer.valueOf(2)).build();
    }

    public Message getMessage() {
        return this.message;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }
}

