/*
 * Decompiled with CFR 0.152.
 */
package io.elastic.sailor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentResolver {
    private static final Logger logger = LoggerFactory.getLogger(ComponentResolver.class);
    private static final String FILENAME = "/component.json";
    private final JsonObject componentJson = ComponentResolver.loadComponentJson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonObject loadComponentJson() {
        logger.info("Component descriptor from classpath: {}", (Object)FILENAME);
        InputStream stream = ComponentResolver.class.getResourceAsStream(FILENAME);
        if (stream == null) {
            throw new IllegalStateException(String.format("Component descriptor %s is not found in the classpath", FILENAME));
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(stream);
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse((Reader)reader).getAsJsonObject();
            return jsonObject;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close reader", (Throwable)e);
                }
            }
        }
    }

    public String findCredentialsVerifier() {
        JsonObject credentials = this.componentJson.getAsJsonObject("credentials");
        if (credentials == null) {
            return null;
        }
        JsonElement verifier = credentials.get("verifier");
        if (verifier == null) {
            return null;
        }
        return verifier.getAsString();
    }

    public String findTriggerOrAction(String name) {
        JsonObject object = this.findTriggerOrActionObject(name).getAsJsonObject();
        JsonElement main = object.get("main");
        if (main == null) {
            throw new RuntimeException("Main class of '" + name + "' trigger/action is not specified");
        }
        return main.getAsString();
    }

    public JsonElement findTriggerOrActionObject(String name) {
        JsonObject result = null;
        JsonObject triggers = this.componentJson.getAsJsonObject("triggers");
        JsonObject actions = this.componentJson.getAsJsonObject("actions");
        if (triggers != null && triggers.get(name) != null) {
            result = triggers.getAsJsonObject(name);
        }
        if (actions != null && actions.get(name) != null) {
            result = actions.getAsJsonObject(name);
        }
        if (result == null) {
            throw new RuntimeException("'" + name + "' trigger or action is not found");
        }
        return result;
    }
}

