/*
 *  Copyright 2006 Hannes Wallnoefer <hannes@helma.at>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ringojs.test;

import org.ringojs.util.StringUtils;
import junit.framework.TestCase;

public class StringUtilsTest extends TestCase {

    public void testNullPath() {
        String[] path = StringUtils.split(null, "/");
        assertEquals(path.length, 0);
    }

    public void testBogusPath() {
        String[] path = StringUtils.split("//FOO/// bar ///", "/");
        assertEquals(path.length, 2);
        assertEquals("FOO", path[0]);
        assertEquals(" bar ", path[1]);
    }

}
