/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.hk2.impl;

import cucumber.runtime.Env;
import cucumber.runtime.java.hk2.ServiceLocatorSource;
import cucumber.runtime.java.hk2.impl.CucumberHK2Exception;
import java.text.MessageFormat;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class ServiceLocatorSourceFactory {
    public static final String HK2_LOCATOR_SOURCE_KEY = "hk2.locator-source";
    private final Env env;

    public ServiceLocatorSourceFactory(Env env) {
        this.env = env;
    }

    public ServiceLocatorSource create() {
        String locatorSourceClassName = this.env.get(HK2_LOCATOR_SOURCE_KEY);
        if (locatorSourceClassName == null) {
            return this.createDefaultServiceLocatorSource();
        }
        return this.createUserSpecifiedServiceLocatorSource(locatorSourceClassName);
    }

    private ServiceLocatorSource createDefaultServiceLocatorSource() {
        return () -> {
            ServiceLocator serviceLocator = ServiceLocatorFactory.getInstance().find("cucumber-default");
            if (serviceLocator == null) {
                serviceLocator = ServiceLocatorUtilities.createAndPopulateServiceLocator((String)"cucumber-default");
            }
            return serviceLocator;
        };
    }

    private ServiceLocatorSource createUserSpecifiedServiceLocatorSource(String serviceLocatorSourceClassName) {
        try {
            return (ServiceLocatorSource)Class.forName(serviceLocatorSourceClassName).newInstance();
        }
        catch (Exception e) {
            String message = MessageFormat.format("Instantiation of ''{0}'' failed. Check the caused by exception and ensure yourServiceLocatorSource implementation is accessible and has a public zero args constructor.", serviceLocatorSourceClassName);
            throw new CucumberHK2Exception(message, e);
        }
    }
}

