/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.hk2.impl;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.Env;
import cucumber.runtime.java.hk2.ScenarioScoped;
import cucumber.runtime.java.hk2.ServiceLocatorSource;
import cucumber.runtime.java.hk2.impl.CucumberHK2Exception;
import cucumber.runtime.java.hk2.impl.ScenarioContext;
import cucumber.runtime.java.hk2.impl.ServiceLocatorSourceFactory;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class HK2Factory
implements ObjectFactory {
    private final ServiceLocatorSource locatorSource;
    private Set<Class<?>> cucumberClasses = new HashSet();
    private boolean initialized = false;
    private ServiceLocator locator;
    private ScenarioContext context;

    public HK2Factory() {
        this(new ServiceLocatorSourceFactory(Env.INSTANCE).create());
    }

    HK2Factory(ServiceLocatorSource locatorSource) {
        this.locatorSource = locatorSource;
    }

    public boolean addClass(Class<?> clazz) {
        this.cucumberClasses.add(clazz);
        return true;
    }

    public void start() {
        this.initLocator();
    }

    private void initLocator() {
        if (this.initialized) {
            return;
        }
        this.locator = this.locatorSource.getServiceLocator();
        if (this.locator == null) {
            throw new CucumberHK2Exception("The ServiceLocator cannot be null!");
        }
        ServiceLocatorUtilities.bind((ServiceLocator)this.locator, (Binder[])new Binder[]{new AbstractBinder(){

            protected void configure() {
                this.addActiveDescriptor(ScenarioContext.class);
                for (Class clazz : HK2Factory.this.cucumberClasses) {
                    this.bindAsContract(clazz).in(ScenarioScoped.class);
                }
            }
        }});
        this.context = (ScenarioContext)this.locator.getService(ScenarioContext.class, new Annotation[0]);
        this.initialized = true;
    }

    public void stop() {
        this.context.clear();
    }

    public <T> T getInstance(Class<T> clazz) {
        return (T)this.locator.getService(clazz, new Annotation[0]);
    }
}

