/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.sqllite;

import com.google.inject.name.Names;
import io.edurt.gcm.common.utils.PropertiesUtils;
import io.edurt.gcm.sqllite.SQLLiteProvider;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.mybatis.guice.MyBatisModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLLiteModule
extends MyBatisModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLLiteModule.class);
    private final String configuration;

    public SQLLiteModule(String configuration) {
        this.configuration = configuration;
    }

    public SQLLiteModule() {
        this.configuration = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "conf", "catalog", "sqllite.properties");
    }

    protected void initialize() {
        LOGGER.info("binding sqllite by hikari datasource configuration information is started.");
        LOGGER.info("load configuration from local file {}", (Object)this.configuration);
        Properties configuration = PropertiesUtils.loadProperties((String[])new String[]{this.configuration});
        LOGGER.info("binding sqllite by hikari datasource configuration information is completed, with a total of {} configurations", (Object)configuration.stringPropertyNames().size());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"mybatis.environment.id")).to("Prod");
        this.bindDataSourceProvider(new SQLLiteProvider(configuration));
        this.bindTransactionFactoryType(JdbcTransactionFactory.class);
        this.addMapperClasses(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.sqllite.scan.mapper.package", (String)"io.edurt.gcm.sqllite.mapper"));
    }
}

