/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.sqllite;

import com.google.inject.Provider;
import com.zaxxer.hikari.HikariDataSource;
import io.edurt.gcm.common.utils.PropertiesUtils;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLLiteProvider
implements Provider<DataSource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLLiteProvider.class);
    private final HikariDataSource dataSource = new HikariDataSource();

    public SQLLiteProvider(Properties configuration) {
        LOGGER.info("generate configuration");
        this.dataSource.setDriverClassName(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.sqllite.driverClassName", (String)"org.sqlite.JDBC"));
        this.dataSource.setJdbcUrl(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.sqllite.url", (String)"jdbc:sqlite:test"));
        this.dataSource.setUsername(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.sqllite.username", (String)""));
        this.dataSource.setPassword(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.sqllite.password", (String)""));
        this.dataSource.setMinimumIdle(PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.sqllite.minimumIdle", (Integer)10).intValue());
        this.dataSource.setMaximumPoolSize(PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.sqllite.maximumPoolSize", (Integer)100).intValue());
        this.dataSource.setConnectionTestQuery(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.sqllite.connectionTestQuery", (String)"select 1"));
        this.dataSource.addDataSourceProperty("cachePrepStmts", (Object)PropertiesUtils.getBoolValue((Properties)configuration, (String)"jdbc.sqllite.cachePrepStmts", (Boolean)true));
        this.dataSource.addDataSourceProperty("prepStmtCacheSize", (Object)PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.sqllite.prepStmtCacheSize", (Integer)300));
        this.dataSource.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.sqllite.prepStmtCacheSqlLimit", (Integer)2048));
        this.dataSource.addDataSourceProperty("useServerPrepStmts", (Object)PropertiesUtils.getBoolValue((Properties)configuration, (String)"jdbc.sqllite.useServerPrepStmts", (Boolean)true));
    }

    public DataSource get() {
        return this.dataSource;
    }
}

