/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.mysql.hikari;

import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.name.Names;
import io.edurt.gcm.common.utils.PropertiesUtils;
import io.edurt.gcm.mysql.hikari.MySQLHikariProvider;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.mybatis.guice.MyBatisModule;
import org.mybatis.guice.datasource.helper.JdbcHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLHikariMultipleModule
extends PrivateModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLHikariMultipleModule.class);
    private final String configuration;

    public MySQLHikariMultipleModule(String configuration) {
        this.configuration = configuration;
    }

    public MySQLHikariMultipleModule() {
        this.configuration = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "conf", "catalog", "mysql.properties");
    }

    protected void configure() {
        LOGGER.info("binding hikari datasource configuration information is started.");
        LOGGER.info("load configuration from local file {}", (Object)this.configuration);
        final Properties configuration = PropertiesUtils.loadProperties((String[])new String[]{this.configuration});
        LOGGER.info("binding hikari datasource configuration information is completed, with a total of {} configurations", (Object)configuration.stringPropertyNames().size());
        final String scanPackage = PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.mysql.scan.mapper.package", (String)"io.edurt.gcm.mysql.hikari.mapper");
        this.install((Module)new MyBatisModule(){

            protected void initialize() {
                this.install((Module)JdbcHelper.MySQL);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"mybatis.environment.id")).to("Prod");
                this.bindDataSourceProvider(new MySQLHikariProvider(configuration));
                this.bindTransactionFactoryType(JdbcTransactionFactory.class);
                this.addMapperClasses(scanPackage);
            }
        });
        new ResolverUtil().find((ResolverUtil.Test)new ResolverUtil.IsA(Object.class), scanPackage).getClasses().forEach(arg_0 -> ((MySQLHikariMultipleModule)this).expose(arg_0));
    }
}

