/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.mysql.hikari;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.edurt.gcm.common.utils.PropertiesUtils;
import io.edurt.gcm.mysql.hikari.MySQLHikariProvider;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.mybatis.guice.MyBatisModule;
import org.mybatis.guice.datasource.helper.JdbcHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLHikariModule
extends MyBatisModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractModule.class);
    private final String configuration;

    public MySQLHikariModule(String configuration) {
        this.configuration = configuration;
    }

    public MySQLHikariModule() {
        this.configuration = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "conf", "catalog", "mysql.properties");
    }

    protected void initialize() {
        LOGGER.info("binding hikari datasource configuration information is started.");
        LOGGER.info("load configuration from local file {}", (Object)this.configuration);
        Properties configuration = PropertiesUtils.loadProperties((String[])new String[]{this.configuration});
        LOGGER.info("binding hikari datasource configuration information is completed, with a total of {} configurations", (Object)configuration.stringPropertyNames().size());
        this.install((Module)JdbcHelper.MySQL);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"mybatis.environment.id")).to("Prod");
        this.bindDataSourceProvider(new MySQLHikariProvider(configuration));
        this.bindTransactionFactoryType(JdbcTransactionFactory.class);
        this.addMapperClasses(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.mysql.scan.mapper.package", (String)"io.edurt.gcm.mysql.hikari.mapper"));
    }
}

