/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.mysql.hikari;

import com.google.inject.Provider;
import com.zaxxer.hikari.HikariDataSource;
import io.edurt.gcm.common.utils.PropertiesUtils;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLHikariProvider
implements Provider<DataSource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLHikariProvider.class);
    private final HikariDataSource dataSource = new HikariDataSource();

    public MySQLHikariProvider(Properties configuration) {
        LOGGER.info("generate configuration");
        this.dataSource.setDriverClassName(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.mysql.driverClassName", (String)"com.mysql.jdbc.Driver"));
        this.dataSource.setJdbcUrl(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.mysql.url", (String)"jdbc:mysql://localhost:3306/test?characterEncoding=utf8&amp;useSSL=true&amp;allowMultiQueries=true&amp;zeroDateTimeBehavior=convertToNull"));
        this.dataSource.setUsername(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.mysql.username", (String)"root"));
        this.dataSource.setPassword(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.mysql.password", (String)"123"));
        this.dataSource.setMinimumIdle(PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.mysql.minimumIdle", (Integer)10).intValue());
        this.dataSource.setMaximumPoolSize(PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.mysql.maximumPoolSize", (Integer)100).intValue());
        this.dataSource.setConnectionTestQuery(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.mysql.connectionTestQuery", (String)"select 1"));
        this.dataSource.addDataSourceProperty("cachePrepStmts", (Object)PropertiesUtils.getBoolValue((Properties)configuration, (String)"jdbc.mysql.cachePrepStmts", (Boolean)true));
        this.dataSource.addDataSourceProperty("prepStmtCacheSize", (Object)PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.mysql.prepStmtCacheSize", (Integer)300));
        this.dataSource.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.mysql.prepStmtCacheSqlLimit", (Integer)2048));
        this.dataSource.addDataSourceProperty("useServerPrepStmts", (Object)PropertiesUtils.getBoolValue((Properties)configuration, (String)"jdbc.mysql.useServerPrepStmts", (Boolean)true));
    }

    public DataSource get() {
        return this.dataSource;
    }
}

