/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.h2;

import com.google.inject.Provider;
import com.zaxxer.hikari.HikariDataSource;
import io.edurt.gcm.common.utils.PropertiesUtils;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Provider
implements Provider<DataSource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(H2Provider.class);
    private final HikariDataSource dataSource = new HikariDataSource();

    public H2Provider(Properties configuration) {
        LOGGER.info("generate configuration");
        this.dataSource.setDriverClassName(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.h2.driverClassName", (String)"org.h2.Driver"));
        this.dataSource.setJdbcUrl(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.h2.url", (String)"jdbc:h2:./test"));
        this.dataSource.setUsername(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.h2.username", (String)""));
        this.dataSource.setPassword(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.h2.password", (String)""));
        this.dataSource.setMinimumIdle(PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.h2.minimumIdle", (Integer)10).intValue());
        this.dataSource.setMaximumPoolSize(PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.h2.maximumPoolSize", (Integer)100).intValue());
        this.dataSource.setConnectionTestQuery(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.h2.connectionTestQuery", (String)"select 1"));
        this.dataSource.addDataSourceProperty("cachePrepStmts", (Object)PropertiesUtils.getBoolValue((Properties)configuration, (String)"jdbc.h2.cachePrepStmts", (Boolean)true));
        this.dataSource.addDataSourceProperty("prepStmtCacheSize", (Object)PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.h2.prepStmtCacheSize", (Integer)300));
        this.dataSource.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.h2.prepStmtCacheSqlLimit", (Integer)2048));
        this.dataSource.addDataSourceProperty("useServerPrepStmts", (Object)PropertiesUtils.getBoolValue((Properties)configuration, (String)"jdbc.h2.useServerPrepStmts", (Boolean)true));
    }

    public DataSource get() {
        return this.dataSource;
    }
}

