/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.h2;

import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.name.Names;
import io.edurt.gcm.common.utils.ObjectUtils;
import io.edurt.gcm.common.utils.PropertiesUtils;
import io.edurt.gcm.h2.H2Provider;
import io.edurt.gcm.h2.annotation.H2Source;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.mybatis.guice.MyBatisModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2MultipleModule
extends PrivateModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(H2MultipleModule.class);
    private final String configuration;

    public H2MultipleModule(String configuration) {
        this.configuration = configuration;
    }

    public H2MultipleModule() {
        this.configuration = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "conf", "catalog", "h2.properties");
    }

    protected void configure() {
        LOGGER.info("binding h2 by hikari datasource configuration information is started.");
        LOGGER.info("load configuration from local file {}", (Object)this.configuration);
        final Properties configuration = PropertiesUtils.loadProperties((String[])new String[]{this.configuration});
        LOGGER.info("binding h2 by hikari datasource configuration information is completed, with a total of {} configurations", (Object)configuration.stringPropertyNames().size());
        final String scanPackage = PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.h2.scan.mapper.package", (String)"io.edurt.gcm.h2.mapper");
        this.install((Module)new MyBatisModule(){

            protected void initialize() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"mybatis.environment.id")).to("Prod");
                this.bindDataSourceProvider(new H2Provider(configuration));
                this.bindTransactionFactoryType(JdbcTransactionFactory.class);
                ResolverUtil util = new ResolverUtil();
                Set mappers = util.findImplementations(Object.class, new String[]{scanPackage}).getClasses();
                for (Class clazz : mappers) {
                    H2Source annotation = clazz.getAnnotation(H2Source.class);
                    if (!ObjectUtils.isNotEmpty((Object)annotation)) continue;
                    this.addMapperClass(clazz);
                    H2MultipleModule.this.expose(clazz);
                }
                this.addSimpleAliases(scanPackage);
            }
        });
    }
}

