/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.netty.handler;

import com.google.inject.Injector;
import io.edurt.gcm.netty.NettyServer;
import io.edurt.gcm.netty.dispatcher.RequestDispatcher;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServer.class);
    private final Injector injector;
    private final String websocketPath;
    private Properties configuration;

    public HttpRequestHandler(Injector injector, String websocketPath, Properties configuration) {
        this.injector = injector;
        this.websocketPath = websocketPath;
        this.configuration = configuration;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        if (httpRequest.uri().equals(this.websocketPath)) {
            LOGGER.info("Currently, socket service from /{} is not supported", (Object)this.websocketPath);
        } else {
            if (HttpUtil.is100ContinueExpected((HttpMessage)httpRequest)) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
                ctx.writeAndFlush((Object)response);
            }
            DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(httpRequest.protocolVersion(), HttpResponseStatus.OK);
            RequestDispatcher.builderConfiguration(this.configuration);
            ((RequestDispatcher)this.injector.getInstance(RequestDispatcher.class)).processor(ctx, httpRequest, (FullHttpResponse)httpResponse);
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)httpResponse.content().readableBytes());
            if (HttpUtil.isKeepAlive((HttpMessage)httpRequest)) {
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            ctx.write((Object)httpResponse);
            ChannelFuture future = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!HttpUtil.isKeepAlive((HttpMessage)httpRequest)) {
                future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }
}

