/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.netty.dispatcher;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import io.edurt.gcm.common.utils.PropertiesUtils;
import io.edurt.gcm.netty.annotation.RequestBody;
import io.edurt.gcm.netty.annotation.RequestParam;
import io.edurt.gcm.netty.annotation.ResponseBody;
import io.edurt.gcm.netty.dispatcher.DispatchRules;
import io.edurt.gcm.netty.exception.NettyException;
import io.edurt.gcm.netty.filter.SessionFilter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryAttribute;
import io.netty.util.CharsetUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RequestDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestDispatcher.class);
    private static Properties configuration;
    @Inject
    private Injector injector;
    @Inject
    private SessionFilter sessionFilter;

    public static final void builderConfiguration(Properties properties) {
        configuration = properties;
    }

    public void processor(ChannelHandlerContext ctx, FullHttpRequest httpRequest, FullHttpResponse httpResponse) {
        LOGGER.info("Add session filter");
        this.sessionFilter.doFilter(ctx, httpRequest, httpResponse);
    }

    public void triggerAction(FullHttpRequest httpRequest, FullHttpResponse httpResponse) throws Exception {
        Method[] methods;
        URI uri = URI.create(httpRequest.uri());
        String dispatchUri = uri.getPath();
        String dispatchIndex = httpRequest.method().name() + " " + dispatchUri;
        String dispatchValue = DispatchRules.ROUES.get(dispatchIndex);
        LOGGER.info("Obtain and analyze the client request information from {}", (Object)dispatchIndex);
        if (dispatchValue == null) {
            dispatchValue = DispatchRules.ROUES.get(dispatchUri);
        }
        if (dispatchValue == null) {
            httpResponse.setStatus(HttpResponseStatus.NOT_FOUND);
            return;
        }
        String controllerName = dispatchValue.substring(0, dispatchValue.lastIndexOf("."));
        String methodName = dispatchValue.substring(dispatchValue.lastIndexOf(".") + 1);
        String controller = PropertiesUtils.getStringValue((Properties)configuration, (String)"netty.controller.package", (String)"io.edurt.gcm.netty.controller");
        String ctrlClass = controller + "." + controllerName.substring(0, 1).toUpperCase() + controllerName.substring(1) + "Controller";
        try {
            Class.forName(ctrlClass);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Unable to instantiate controller information. Please check whether the package name is correct and the system specified path is {}", (Object)controller);
            httpResponse.setStatus(HttpResponseStatus.NOT_FOUND);
            return;
        }
        LOGGER.debug("Parsing method parameters, used to inject the corresponding entity!");
        ArrayList classList = new ArrayList();
        ArrayList<Object> objectList = new ArrayList<Object>();
        Object ctrlObject = this.injector.getInstance(Class.forName(ctrlClass));
        LOGGER.debug("Current execute controller {}", ctrlObject);
        Map<String, String> requestParams = this.getRequestParams((HttpRequest)httpRequest);
        for (Method method : methods = ctrlObject.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            for (Parameter parameter : method.getParameters()) {
                Class<?> parameterClass = Class.forName(parameter.getType().getTypeName());
                if (parameterClass == FullHttpRequest.class) {
                    LOGGER.debug("Processing data information carried by FullHttpRequest");
                    objectList.add(httpRequest);
                    classList.add(parameterClass);
                    continue;
                }
                if (parameterClass == FullHttpResponse.class) {
                    LOGGER.debug("Processing data information carried by FullHttpResponse");
                    objectList.add(httpResponse);
                    classList.add(parameterClass);
                    continue;
                }
                if (parameter.getAnnotation(RequestParam.class) != null) {
                    LOGGER.debug("Processing data information carried by RequestParam");
                    String requestParamKey = parameter.getAnnotation(RequestParam.class).value();
                    String requestParamVal = requestParams.get(requestParamKey);
                    if (parameterClass == Long.class) {
                        objectList.add(Long.valueOf(requestParamVal));
                        classList.add(Long.class);
                        continue;
                    }
                    if (parameterClass == Integer.class) {
                        objectList.add(Integer.valueOf(requestParamVal));
                        classList.add(Integer.class);
                        continue;
                    }
                    objectList.add(String.valueOf(requestParamVal));
                    classList.add(String.class);
                    continue;
                }
                if (parameter.getAnnotation(RequestBody.class) != null) {
                    LOGGER.debug("Processing data information carried by RequestBody");
                    ByteBuf bf = httpRequest.content();
                    byte[] byteArray = new byte[bf.capacity()];
                    bf.readBytes(byteArray);
                    objectList.add(new Gson().fromJson(new String(byteArray), parameterClass));
                    classList.add(parameterClass);
                    continue;
                }
                LOGGER.debug("Ignore it if it is not resolved");
                objectList.add(null);
                classList.add(Object.class);
            }
            break;
        }
        Class[] classes = classList.toArray(new Class[classList.size()]);
        Object[] objects = objectList.toArray();
        Method method = ctrlObject.getClass().getMethod(methodName, classes);
        String content = null;
        if (method.isAnnotationPresent(ResponseBody.class)) {
            Gson gson = new Gson();
            try {
                content = gson.toJson(method.invoke(ctrlObject, objects));
                httpResponse.setStatus(HttpResponseStatus.OK);
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause().getClass() == NettyException.class) {
                    NettyException exception = (NettyException)ex.getCause();
                    content = gson.toJson((Object)exception);
                } else {
                    ex.printStackTrace();
                    content = gson.toJson((Object)new NettyException(500, ex.getCause().getMessage()));
                }
                httpResponse.setStatus(HttpResponseStatus.BAD_GATEWAY);
            }
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json; charset=UTF-8");
        } else {
            LOGGER.warn("We don't do any processing here for the time being, and we will support it later");
        }
        httpResponse.content().writeBytes(Unpooled.copiedBuffer(content, (Charset)CharsetUtil.UTF_8));
    }

    private Map<String, String> getRequestParams(HttpRequest request) {
        QueryStringDecoder decoder;
        LOGGER.debug("Processing get post requests, current method {}", (Object)request.method());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        if (request.method() == HttpMethod.GET || request.method() == HttpMethod.POST) {
            decoder = new QueryStringDecoder(request.uri());
            Map params = decoder.parameters();
            for (Map.Entry next : params.entrySet()) {
                requestParams.put((String)next.getKey(), (String)((List)next.getValue()).get(0));
            }
        }
        if (request.method() == HttpMethod.POST) {
            decoder = new HttpPostRequestDecoder((HttpDataFactory)new DefaultHttpDataFactory(false), request);
            List postData = decoder.getBodyHttpDatas();
            for (InterfaceHttpData data : postData) {
                if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                MemoryAttribute attribute = (MemoryAttribute)data;
                requestParams.put(attribute.getName(), attribute.getValue());
            }
        }
        return requestParams;
    }
}

