/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.netty;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.edurt.gcm.common.utils.PropertiesUtils;
import io.edurt.gcm.netty.handler.HttpRequestHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyServer.class);
    private static Properties configuration;
    @Inject
    private Injector injector;
    @Inject
    private EventLoopGroup bossGroup;
    @Inject
    private EventLoopGroup workerGroup;

    public static final void binder(Properties properties) {
        configuration = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        String host = PropertiesUtils.getStringValue((Properties)configuration, (String)"netty.host", (String)"localhost");
        int port = PropertiesUtils.getIntValue((Properties)configuration, (String)"netty.port", (Integer)8080);
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)this.channelInitializer()).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            LOGGER.info("Running ServerBootstrap on {}:{}", (Object)host, (Object)port);
            ChannelFuture f = bootstrap.bind(host, port).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            this.workerGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
        }
    }

    private ChannelInitializer channelInitializer() {
        return new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                pipeline.addLast(new ChannelHandler[]{new HttpRequestHandler(NettyServer.this.injector, "/socket", configuration)});
            }
        };
    }
}

