/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.netty;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import io.edurt.gcm.common.utils.PropertiesUtils;
import io.edurt.gcm.netty.NettyServer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.File;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyModule.class);

    public void configure() {
        LOGGER.debug("Binding netty component information");
        String configurationPath = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "conf", "catalog", "netty.properties");
        Properties configuration = PropertiesUtils.loadProperties((String[])new String[]{configurationPath});
        LOGGER.info("Binding netty configuration information is completed, with a total of {} configurations", (Object)configuration.stringPropertyNames().size());
        NettyServer.binder(configuration);
    }

    @Provides
    public EventLoopGroup eventLoopGroup() {
        return new NioEventLoopGroup();
    }
}

