/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.derby;

import com.google.inject.Provider;
import com.zaxxer.hikari.HikariDataSource;
import io.edurt.gcm.common.utils.PropertiesUtils;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyProvider
implements Provider<DataSource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerbyProvider.class);
    private final HikariDataSource dataSource = new HikariDataSource();

    public DerbyProvider(Properties configuration) {
        LOGGER.info("generate configuration");
        this.dataSource.setDriverClassName(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.derby.driverClassName", (String)"org.apache.derby.jdbc.EmbeddedDriver"));
        this.dataSource.setJdbcUrl(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.derby.url", (String)"jdbc:derby:derbyDB;create=true"));
        this.dataSource.setUsername(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.derby.username", (String)""));
        this.dataSource.setPassword(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.derby.password", (String)""));
        this.dataSource.setMinimumIdle(PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.derby.minimumIdle", (Integer)10).intValue());
        this.dataSource.setMaximumPoolSize(PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.derby.maximumPoolSize", (Integer)100).intValue());
        this.dataSource.setConnectionTestQuery(PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.derby.connectionTestQuery", (String)"select 1"));
        this.dataSource.addDataSourceProperty("cachePrepStmts", (Object)PropertiesUtils.getBoolValue((Properties)configuration, (String)"jdbc.derby.cachePrepStmts", (Boolean)true));
        this.dataSource.addDataSourceProperty("prepStmtCacheSize", (Object)PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.derby.prepStmtCacheSize", (Integer)300));
        this.dataSource.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)PropertiesUtils.getIntValue((Properties)configuration, (String)"jdbc.derby.prepStmtCacheSqlLimit", (Integer)2048));
        this.dataSource.addDataSourceProperty("useServerPrepStmts", (Object)PropertiesUtils.getBoolValue((Properties)configuration, (String)"jdbc.derby.useServerPrepStmts", (Boolean)true));
    }

    public DataSource get() {
        return this.dataSource;
    }
}

