/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.derby;

import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.name.Names;
import io.edurt.gcm.common.utils.ObjectUtils;
import io.edurt.gcm.common.utils.PropertiesUtils;
import io.edurt.gcm.derby.DerbyProvider;
import io.edurt.gcm.derby.annotation.DerbySource;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.mybatis.guice.MyBatisModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyMultipleModule
extends PrivateModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(DerbyMultipleModule.class);
    private final String configuration;

    public DerbyMultipleModule(String configuration) {
        this.configuration = configuration;
    }

    public DerbyMultipleModule() {
        this.configuration = String.join((CharSequence)File.separator, System.getProperty("user.dir"), "conf", "catalog", "derby.properties");
    }

    protected void configure() {
        LOGGER.info("binding derby by hikari datasource configuration information is started.");
        LOGGER.info("load configuration from local file {}", (Object)this.configuration);
        final Properties configuration = PropertiesUtils.loadProperties((String[])new String[]{this.configuration});
        LOGGER.info("binding derby by hikari datasource configuration information is completed, with a total of {} configurations", (Object)configuration.stringPropertyNames().size());
        final String scanPackage = PropertiesUtils.getStringValue((Properties)configuration, (String)"jdbc.derby.scan.mapper.package", (String)"io.edurt.gcm.derby.mapper");
        this.install((Module)new MyBatisModule(){

            protected void initialize() {
                this.bindConstant().annotatedWith((Annotation)Names.named((String)"mybatis.environment.id")).to("Prod");
                this.bindDataSourceProvider(new DerbyProvider(configuration));
                this.bindTransactionFactoryType(JdbcTransactionFactory.class);
                ResolverUtil util = new ResolverUtil();
                Set mappers = util.findImplementations(Object.class, new String[]{scanPackage}).getClasses();
                for (Class clazz : mappers) {
                    DerbySource annotation = clazz.getAnnotation(DerbySource.class);
                    if (!ObjectUtils.isNotEmpty((Object)annotation)) continue;
                    this.addMapperClass(clazz);
                    DerbyMultipleModule.this.expose(clazz);
                }
                this.addSimpleAliases(scanPackage);
            }
        });
    }
}

