/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.configuration;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.name.Names;
import io.edurt.gcm.common.utils.PropertiesUtils;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationModule.class);
    private Properties bootstrapConfiguration;

    public ConfigurationModule(Properties bootstrapConfiguration) {
        this.bootstrapConfiguration = bootstrapConfiguration;
    }

    public ConfigurationModule(String configurationFilePath) {
        LOGGER.info("Load the local configuration file with the path address of {}", (Object)configurationFilePath);
        if (ObjectUtils.isNotEmpty((Object)configurationFilePath)) {
            this.bootstrapConfiguration = PropertiesUtils.loadProperties((String[])new String[]{configurationFilePath});
        }
    }

    protected void configure() {
        LOGGER.info("start binding configuration file related configuration information");
        this.bootstrapConfiguration.stringPropertyNames().forEach(v -> LOGGER.info("the primary key of the binding configuration information is {}, and the value is {}", v, this.bootstrapConfiguration.get(v)));
        Names.bindProperties((Binder)this.binder(), (Properties)this.bootstrapConfiguration);
        LOGGER.info("end of binding configuration file related configuration information, with a total of {} configuration information bound", (Object)this.bootstrapConfiguration.stringPropertyNames().size());
    }
}

