/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.gcm.base.client;

import io.edurt.gcm.base.client.BaseRestfulConfig;
import io.edurt.gcm.base.client.RestfulConnectionFactory;
import io.edurt.gcm.common.utils.ObjectUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRestfulConnectionFactory
implements RestfulConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicRestfulConnectionFactory.class);
    private String connectionUrl;
    private OkHttpClient okHttpClient;
    private final BaseRestfulConfig config;

    private BasicRestfulConnectionFactory(BaseRestfulConfig config) {
        this.config = config;
    }

    public static BasicRestfulConnectionFactory builder(BaseRestfulConfig config) {
        return new BasicRestfulConnectionFactory(config);
    }

    @Override
    public OkHttpClient openConnection(BaseRestfulConfig config) {
        this.okHttpClient = new OkHttpClient.Builder().callTimeout((long)config.getTimeout().intValue(), TimeUnit.SECONDS).build();
        this.connectionUrl = String.format("%s://%s:%s/%s", config.getProtocol(), config.getHost(), config.getPort(), config.getPath());
        return this.okHttpClient;
    }

    @Override
    public Response postExecute(Map<String, Object> params) {
        return null;
    }

    @Override
    public Response getExecute(Map<String, Object> params) throws IOException {
        this.openConnection(this.config);
        LOGGER.debug("Execute get method on {}", (Object)this.connectionUrl);
        Request.Builder requestBuilder = new Request.Builder();
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.connectionUrl).newBuilder();
        if (ObjectUtils.isNotEmpty(params)) {
            params.entrySet().forEach(entry -> httpUrl.addQueryParameter((String)entry.getKey(), String.valueOf(entry.getValue())));
        }
        requestBuilder.url(httpUrl.build());
        Request request = requestBuilder.build();
        return this.okHttpClient.newCall(request).execute();
    }

    @Override
    public Response getExecute() throws IOException {
        return this.getExecute(null);
    }
}

