/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.service.file.oss;

import com.aliyun.oss.OSSClient;
import io.easyspring.service.file.EasyFileException;
import io.easyspring.service.file.FileUploader;
import io.easyspring.service.file.oss.OssClientUtils;
import io.easyspring.service.file.support.SimpleUserFile;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class OssFileUploader
implements FileUploader {
    private static final Logger log = LoggerFactory.getLogger(OssFileUploader.class);
    @Autowired
    private OssClientUtils ossClientUtils;

    @Override
    public SimpleUserFile putObject(String bucketName, String objectName, File uploadFile) {
        OSSClient ossClient = this.ossClientUtils.getOssClient();
        ossClient.putObject(bucketName, objectName, uploadFile);
        ossClient.shutdown();
        return this.buildSimpleUserFile(bucketName, objectName);
    }

    @Override
    public SimpleUserFile putObject(String bucketName, String objectName, InputStream fileInputStream) {
        OSSClient ossClient = this.ossClientUtils.getOssClient();
        ossClient.putObject(bucketName, objectName, fileInputStream);
        ossClient.shutdown();
        return this.buildSimpleUserFile(bucketName, objectName);
    }

    private SimpleUserFile buildSimpleUserFile(String bucketName, String objectName) {
        if (StringUtils.isEmpty((Object)bucketName)) {
            throw new EasyFileException("\u6587\u4ef6\u5b58\u50a8\u533a\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)objectName)) {
            throw new EasyFileException("\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleUserFile simpleUserFile = new SimpleUserFile();
        simpleUserFile.setBucketName(bucketName);
        simpleUserFile.setObjectName(objectName);
        return simpleUserFile;
    }

    public OssClientUtils getOssClientUtils() {
        return this.ossClientUtils;
    }

    public void setOssClientUtils(OssClientUtils ossClientUtils) {
        this.ossClientUtils = ossClientUtils;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssFileUploader)) {
            return false;
        }
        OssFileUploader other = (OssFileUploader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OssClientUtils this$ossClientUtils = this.getOssClientUtils();
        OssClientUtils other$ossClientUtils = other.getOssClientUtils();
        return !(this$ossClientUtils == null ? other$ossClientUtils != null : !this$ossClientUtils.equals(other$ossClientUtils));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OssFileUploader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OssClientUtils $ossClientUtils = this.getOssClientUtils();
        result = result * 59 + ($ossClientUtils == null ? 43 : $ossClientUtils.hashCode());
        return result;
    }

    public String toString() {
        return "OssFileUploader(ossClientUtils=" + this.getOssClientUtils() + ")";
    }
}

