/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.service.file.oss;

import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import io.easyspring.service.file.FileDownloader;
import io.easyspring.service.file.oss.OssClientUtils;
import io.easyspring.service.file.properties.FileProperties;
import io.easyspring.service.file.properties.OssProperties;
import io.easyspring.service.file.support.SimpleUserFile;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class OssFileDownloader
implements FileDownloader {
    private static final Logger log = LoggerFactory.getLogger(OssFileDownloader.class);
    @Autowired
    private FileProperties fileProperties;
    @Autowired
    private OssClientUtils ossClientUtils;

    @Override
    public String getUrl(SimpleUserFile simpleUserFile, Long expiration, String style) {
        OssProperties ossProperties = this.fileProperties.getOss();
        OSSClient ossClient = this.ossClientUtils.getOssClient();
        expiration = expiration == null || expiration < 1L ? ossProperties.getDefaultExpiration() : expiration;
        Date expirationTime = new Date(System.currentTimeMillis() + expiration);
        GeneratePresignedUrlRequest req = new GeneratePresignedUrlRequest(simpleUserFile.getBucketName(), simpleUserFile.getObjectName(), HttpMethod.GET);
        req.setExpiration(expirationTime);
        if (!StringUtils.isEmpty((Object)style)) {
            req.setProcess(style);
        }
        URL signedUrl = ossClient.generatePresignedUrl(req);
        ossClient.shutdown();
        return signedUrl.toString();
    }

    public FileProperties getFileProperties() {
        return this.fileProperties;
    }

    public OssClientUtils getOssClientUtils() {
        return this.ossClientUtils;
    }

    public void setFileProperties(FileProperties fileProperties) {
        this.fileProperties = fileProperties;
    }

    public void setOssClientUtils(OssClientUtils ossClientUtils) {
        this.ossClientUtils = ossClientUtils;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OssFileDownloader)) {
            return false;
        }
        OssFileDownloader other = (OssFileDownloader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileProperties this$fileProperties = this.getFileProperties();
        FileProperties other$fileProperties = other.getFileProperties();
        if (this$fileProperties == null ? other$fileProperties != null : !((Object)this$fileProperties).equals(other$fileProperties)) {
            return false;
        }
        OssClientUtils this$ossClientUtils = this.getOssClientUtils();
        OssClientUtils other$ossClientUtils = other.getOssClientUtils();
        return !(this$ossClientUtils == null ? other$ossClientUtils != null : !this$ossClientUtils.equals(other$ossClientUtils));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OssFileDownloader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileProperties $fileProperties = this.getFileProperties();
        result = result * 59 + ($fileProperties == null ? 43 : ((Object)$fileProperties).hashCode());
        OssClientUtils $ossClientUtils = this.getOssClientUtils();
        result = result * 59 + ($ossClientUtils == null ? 43 : $ossClientUtils.hashCode());
        return result;
    }

    public String toString() {
        return "OssFileDownloader(fileProperties=" + this.getFileProperties() + ", ossClientUtils=" + this.getOssClientUtils() + ")";
    }
}

