/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.service.file.oss;

import com.aliyun.oss.OSSClient;
import io.easyspring.service.file.EasyFileException;
import io.easyspring.service.file.properties.FileProperties;
import io.easyspring.service.file.properties.OssProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class OssClientUtils {
    @Autowired
    private FileProperties fileProperties;

    public OSSClient getOssClient() {
        OssProperties ossProperties = this.fileProperties.getOss();
        if (!OssClientUtils.ossClientPropertiesValid(ossProperties)) {
            throw new EasyFileException("\u521b\u5efaOSSClient\u5b9e\u4f8b\u5931\u8d25");
        }
        return new OSSClient(ossProperties.getEndpoint(), ossProperties.getAccessKeyId(), ossProperties.getAccessKeySecret());
    }

    private static boolean ossClientPropertiesValid(OssProperties ossProperties) {
        if (ossProperties == null) {
            throw new EasyFileException("oss \u914d\u7f6e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u67e5\u770b\u914d\u7f6e easy-spring.file.oss");
        }
        if (StringUtils.isEmpty((Object)ossProperties.getEndpoint())) {
            throw new EasyFileException("oss \u8fde\u63a5\u7684\u670d\u52a1\u5668\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u67e5\u770b\u914d\u7f6e easy-spring.file.oss.endpoint");
        }
        if (StringUtils.isEmpty((Object)ossProperties.getAccessKeyId())) {
            throw new EasyFileException("oss \u8bc6\u522b\u7801 id \u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u67e5\u770b\u914d\u7f6e easy-spring.file.oss.access-key-id");
        }
        if (StringUtils.isEmpty((Object)ossProperties.getAccessKeySecret())) {
            throw new EasyFileException("oss \u7684\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u67e5\u770b\u914d\u7f6e easy-spring.file.oss.access-key-secret");
        }
        return true;
    }
}

