/*
 * Decompiled with CFR 0.152.
 */
package io.easyspring.service.file;

import io.easyspring.service.file.EasyFileException;
import io.easyspring.service.file.FilePlatformEnum;
import io.easyspring.service.file.FileProcessor;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FileProcessorHolder {
    @Autowired
    private Map<String, FileProcessor> fileProcessorMap;

    public FileProcessor findFileProcessor(FilePlatformEnum filePlatform) {
        if (filePlatform == null) {
            throw new EasyFileException("\u6587\u4ef6\u5b58\u50a8\u5e73\u53f0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.findFileProcessor(filePlatform.toString().toLowerCase());
    }

    public FileProcessor findFileProcessor(String filePlatform) {
        if (StringUtils.isEmpty((Object)filePlatform)) {
            throw new EasyFileException("\u6587\u4ef6\u5b58\u50a8\u5e73\u53f0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileProcessorName = filePlatform.toLowerCase() + FileProcessor.class.getSimpleName();
        FileProcessor fileProcessor = this.fileProcessorMap.get(fileProcessorName);
        if (fileProcessor == null) {
            throw new EasyFileException("\u6587\u4ef6\u5904\u7406\u5668" + fileProcessorName + "\u4e0d\u5b58\u5728");
        }
        return fileProcessor;
    }
}

