/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.bundles.webjars;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import io.dropwizard.Bundle;
import io.dropwizard.bundles.webjars.Asset;
import io.dropwizard.bundles.webjars.AssetId;
import io.dropwizard.bundles.webjars.WebJarServlet;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Collections;
import java.util.List;
import javax.servlet.Servlet;

public class WebJarBundle
implements Bundle {
    private CacheBuilder<AssetId, Asset> cacheBuilder = null;
    private List<String> packages = Lists.newArrayList((Object[])WebJarServlet.DEFAULT_MAVEN_GROUPS);
    private String urlPrefix = "/webjars/";

    public WebJarBundle() {
    }

    public WebJarBundle(CacheBuilder<AssetId, Asset> builder) {
        this.cacheBuilder = builder;
    }

    public WebJarBundle(String ... additionalPackages) {
        Collections.addAll(this.packages, additionalPackages);
    }

    public WebJarBundle(CacheBuilder<AssetId, Asset> builder, String ... additionalPackages) {
        this.cacheBuilder = builder;
        Collections.addAll(this.packages, additionalPackages);
    }

    public WebJarBundle withUrlPrefix(String prefix) {
        this.urlPrefix = prefix;
        return this;
    }

    private String normalizedUrlPrefix() {
        StringBuilder pathBuilder = new StringBuilder();
        if (!this.urlPrefix.startsWith("/")) {
            pathBuilder.append('/');
        }
        pathBuilder.append(this.urlPrefix);
        if (!this.urlPrefix.endsWith("/")) {
            pathBuilder.append('/');
        }
        return pathBuilder.toString();
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(Environment environment) {
        String prefix = this.normalizedUrlPrefix();
        WebJarServlet servlet = new WebJarServlet(this.cacheBuilder, this.packages, prefix);
        environment.servlets().addServlet("webjars", (Servlet)servlet).addMapping(new String[]{prefix + "*"});
    }
}

